/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.minecraft.util.commands;

import com.sk89q.minecraft.util.commands.CommandException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CommandContext {
    protected final String command;
    protected final List<String> parsedArgs;
    protected final List<Integer> originalArgIndices;
    protected final String[] originalArgs;
    protected final Set<Character> booleanFlags = new HashSet<Character>();
    protected final Map<Character, String> valueFlags = new HashMap<Character, String>();

    public CommandContext(String args) throws CommandException {
        this(args.split(" "), null);
    }

    public CommandContext(String[] args) throws CommandException {
        this(args, null);
    }

    public CommandContext(String args, Set<Character> valueFlags) throws CommandException {
        this(args.split(" "), valueFlags);
    }

    public CommandContext(String[] args, Set<Character> valueFlags) throws CommandException {
        String arg;
        if (valueFlags == null) {
            valueFlags = Collections.emptySet();
        }
        this.originalArgs = args;
        this.command = args[0];
        ArrayList<Integer> argIndexList = new ArrayList<Integer>(args.length);
        ArrayList<String> argList = new ArrayList<String>(args.length);
        block3: for (int i = 1; i < args.length; ++i) {
            arg = args[i];
            if (arg.length() == 0) continue;
            argIndexList.add(i);
            switch (arg.charAt(0)) {
                case '\"': 
                case '\'': {
                    int endIndex;
                    StringBuilder build = new StringBuilder();
                    char quotedChar = arg.charAt(0);
                    for (endIndex = i; endIndex < args.length; ++endIndex) {
                        String arg2 = args[endIndex];
                        if (arg2.charAt(arg2.length() - 1) == quotedChar && arg2.length() > 1) {
                            if (endIndex != i) {
                                build.append(' ');
                            }
                            build.append(arg2.substring(endIndex == i ? 1 : 0, arg2.length() - 1));
                            break;
                        }
                        if (endIndex == i) {
                            build.append(arg2.substring(1));
                            continue;
                        }
                        build.append(' ').append(arg2);
                    }
                    if (endIndex < args.length) {
                        arg = build.toString();
                        i = endIndex;
                    }
                    if (arg.length() == 0) continue block3;
                }
                default: {
                    argList.add(arg);
                }
            }
        }
        this.originalArgIndices = new ArrayList<Integer>(argIndexList.size());
        this.parsedArgs = new ArrayList<String>(argList.size());
        int nextArg = 0;
        while (nextArg < argList.size()) {
            if ((arg = (String)argList.get(nextArg++)).charAt(0) != '-' || arg.length() == 1 || !arg.matches("^-[a-zA-Z]+$")) {
                this.originalArgIndices.add((Integer)argIndexList.get(nextArg - 1));
                this.parsedArgs.add(arg);
                continue;
            }
            if (arg.equals("--")) {
                while (nextArg < argList.size()) {
                    this.originalArgIndices.add((Integer)argIndexList.get(nextArg));
                    this.parsedArgs.add((String)argList.get(nextArg++));
                }
                break;
            }
            for (int i = 1; i < arg.length(); ++i) {
                char flagName = arg.charAt(i);
                if (valueFlags.contains(Character.valueOf(flagName))) {
                    if (this.valueFlags.containsKey(Character.valueOf(flagName))) {
                        throw new CommandException("Value flag '" + flagName + "' already given");
                    }
                    if (nextArg >= argList.size()) {
                        throw new CommandException("No value specified for the '-" + flagName + "' flag.");
                    }
                    this.valueFlags.put(Character.valueOf(flagName), (String)argList.get(nextArg++));
                    continue;
                }
                this.booleanFlags.add(Character.valueOf(flagName));
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public boolean matches(String command) {
        return this.command.equalsIgnoreCase(command);
    }

    public String getString(int index) {
        return this.parsedArgs.get(index);
    }

    public String getString(int index, String def) {
        return index < this.parsedArgs.size() ? this.parsedArgs.get(index) : def;
    }

    public String getJoinedStrings(int initialIndex) {
        initialIndex = this.originalArgIndices.get(initialIndex);
        StringBuilder buffer = new StringBuilder(this.originalArgs[initialIndex]);
        for (int i = initialIndex + 1; i < this.originalArgs.length; ++i) {
            buffer.append(" ").append(this.originalArgs[i]);
        }
        return buffer.toString();
    }

    public int getInteger(int index) throws NumberFormatException {
        return Integer.parseInt(this.parsedArgs.get(index));
    }

    public int getInteger(int index, int def) throws NumberFormatException {
        return index < this.parsedArgs.size() ? Integer.parseInt(this.parsedArgs.get(index)) : def;
    }

    public double getDouble(int index) throws NumberFormatException {
        return Double.parseDouble(this.parsedArgs.get(index));
    }

    public double getDouble(int index, double def) throws NumberFormatException {
        return index < this.parsedArgs.size() ? Double.parseDouble(this.parsedArgs.get(index)) : def;
    }

    public String[] getSlice(int index) {
        String[] slice = new String[this.originalArgs.length - index];
        System.arraycopy(this.originalArgs, index, slice, 0, this.originalArgs.length - index);
        return slice;
    }

    public String[] getPaddedSlice(int index, int padding) {
        String[] slice = new String[this.originalArgs.length - index + padding];
        System.arraycopy(this.originalArgs, index, slice, padding, this.originalArgs.length - index);
        return slice;
    }

    public String[] getParsedSlice(int index) {
        String[] slice = new String[this.parsedArgs.size() - index];
        System.arraycopy(this.parsedArgs.toArray(new String[this.parsedArgs.size()]), index, slice, 0, this.parsedArgs.size() - index);
        return slice;
    }

    public String[] getParsedPaddedSlice(int index, int padding) {
        String[] slice = new String[this.parsedArgs.size() - index + padding];
        System.arraycopy(this.parsedArgs.toArray(new String[this.parsedArgs.size()]), index, slice, padding, this.parsedArgs.size() - index);
        return slice;
    }

    public boolean hasFlag(char ch2) {
        return this.booleanFlags.contains(Character.valueOf(ch2)) || this.valueFlags.containsKey(Character.valueOf(ch2));
    }

    public Set<Character> getFlags() {
        return this.booleanFlags;
    }

    public Map<Character, String> getValueFlags() {
        return this.valueFlags;
    }

    public String getFlag(char ch2) {
        return this.valueFlags.get(Character.valueOf(ch2));
    }

    public String getFlag(char ch2, String def) {
        String value = this.valueFlags.get(Character.valueOf(ch2));
        if (value == null) {
            return def;
        }
        return value;
    }

    public int getFlagInteger(char ch2) throws NumberFormatException {
        return Integer.parseInt(this.valueFlags.get(Character.valueOf(ch2)));
    }

    public int getFlagInteger(char ch2, int def) throws NumberFormatException {
        String value = this.valueFlags.get(Character.valueOf(ch2));
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    public double getFlagDouble(char ch2) throws NumberFormatException {
        return Double.parseDouble(this.valueFlags.get(Character.valueOf(ch2)));
    }

    public double getFlagDouble(char ch2, double def) throws NumberFormatException {
        String value = this.valueFlags.get(Character.valueOf(ch2));
        if (value == null) {
            return def;
        }
        return Double.parseDouble(value);
    }

    public int argsLength() {
        return this.parsedArgs.size();
    }
}

