/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissionsException;
import com.sk89q.minecraft.util.commands.CommandUsageException;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.minecraft.util.commands.Console;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.minecraft.util.commands.MissingNestedCommandException;
import com.sk89q.minecraft.util.commands.SimpleInjector;
import com.sk89q.minecraft.util.commands.UnhandledCommandException;
import com.sk89q.minecraft.util.commands.WrappedCommandException;
import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.DisallowedItemException;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EditSessionFactory;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.FileSelectionAbortedException;
import com.sk89q.worldedit.FilenameException;
import com.sk89q.worldedit.FilenameResolutionException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.InvalidFilenameException;
import com.sk89q.worldedit.InvalidItemException;
import com.sk89q.worldedit.InvalidToolBindException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LogFormat;
import com.sk89q.worldedit.MaxBrushRadiusException;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MaxRadiusException;
import com.sk89q.worldedit.MobType;
import com.sk89q.worldedit.PlayerDirection;
import com.sk89q.worldedit.PlayerNeededException;
import com.sk89q.worldedit.ServerInterface;
import com.sk89q.worldedit.SessionCheck;
import com.sk89q.worldedit.UnknownDirectionException;
import com.sk89q.worldedit.UnknownItemException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bags.BlockBag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.blocks.ClothColor;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldedit.blocks.MobSpawnerBlock;
import com.sk89q.worldedit.blocks.NoteBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import com.sk89q.worldedit.blocks.SkullBlock;
import com.sk89q.worldedit.commands.BiomeCommands;
import com.sk89q.worldedit.commands.ChunkCommands;
import com.sk89q.worldedit.commands.ClipboardCommands;
import com.sk89q.worldedit.commands.GeneralCommands;
import com.sk89q.worldedit.commands.GenerationCommands;
import com.sk89q.worldedit.commands.HistoryCommands;
import com.sk89q.worldedit.commands.InsufficientArgumentsException;
import com.sk89q.worldedit.commands.NavigationCommands;
import com.sk89q.worldedit.commands.RegionCommands;
import com.sk89q.worldedit.commands.ScriptingCommands;
import com.sk89q.worldedit.commands.SelectionCommands;
import com.sk89q.worldedit.commands.SnapshotUtilCommands;
import com.sk89q.worldedit.commands.ToolCommands;
import com.sk89q.worldedit.commands.ToolUtilCommands;
import com.sk89q.worldedit.commands.UtilityCommands;
import com.sk89q.worldedit.masks.BiomeTypeMask;
import com.sk89q.worldedit.masks.BlockMask;
import com.sk89q.worldedit.masks.CombinedMask;
import com.sk89q.worldedit.masks.DynamicRegionMask;
import com.sk89q.worldedit.masks.ExistingBlockMask;
import com.sk89q.worldedit.masks.InvertedMask;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.masks.RandomMask;
import com.sk89q.worldedit.masks.RegionMask;
import com.sk89q.worldedit.masks.SolidBlockMask;
import com.sk89q.worldedit.masks.UnderOverlayMask;
import com.sk89q.worldedit.patterns.BlockChance;
import com.sk89q.worldedit.patterns.ClipboardPattern;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.RandomFillPattern;
import com.sk89q.worldedit.patterns.SingleBlockPattern;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.scripting.CraftScriptContext;
import com.sk89q.worldedit.scripting.RhinoCraftScriptEngine;
import com.sk89q.worldedit.tools.BlockTool;
import com.sk89q.worldedit.tools.DoubleActionBlockTool;
import com.sk89q.worldedit.tools.DoubleActionTraceTool;
import com.sk89q.worldedit.tools.Tool;
import com.sk89q.worldedit.tools.TraceTool;
import com.sk89q.worldedit.util.StringUtil;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.script.ScriptException;

public class WorldEdit {
    public static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    public final Logger commandLogger = Logger.getLogger("Minecraft.WorldEdit.CommandLogger");
    private static WorldEdit instance;
    private static String version;
    private final ServerInterface server;
    private final LocalConfiguration config;
    private final CommandsManager<LocalPlayer> commands;
    private EditSessionFactory editSessionFactory = new EditSessionFactory();
    private final HashMap<String, LocalSession> sessions = new HashMap();
    private static final java.util.regex.Pattern numberFormatExceptionPattern;

    public WorldEdit(ServerInterface server, final LocalConfiguration config) {
        instance = this;
        this.server = server;
        this.config = config;
        if (!config.logFile.equals("")) {
            try {
                FileHandler logFileHandler = new FileHandler(new File(config.getWorkingDirectory(), config.logFile).getAbsolutePath(), true);
                logFileHandler.setFormatter(new LogFormat());
                this.commandLogger.addHandler(logFileHandler);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Could not use command log file " + config.logFile + ": " + e.getMessage());
            }
        }
        this.commands = new CommandsManager<LocalPlayer>(){

            @Override
            protected void checkPermission(LocalPlayer player, Method method) throws CommandException {
                if (!player.isPlayer() && !method.isAnnotationPresent(Console.class)) {
                    throw new UnhandledCommandException();
                }
                super.checkPermission(player, method);
            }

            @Override
            public boolean hasPermission(LocalPlayer player, String perm) {
                return player.hasPermission(perm);
            }

            @Override
            public void invokeMethod(Method parent, String[] args, LocalPlayer player, Method method, Object instance, Object[] methodArgs, int level) throws CommandException {
                if (config.logCommands) {
                    Logging loggingAnnotation = method.getAnnotation(Logging.class);
                    Logging.LogMode logMode = loggingAnnotation == null ? null : loggingAnnotation.value();
                    String msg = "WorldEdit: " + player.getName();
                    if (player.isPlayer()) {
                        msg = msg + " (in \"" + player.getWorld().getName() + "\")";
                    }
                    msg = msg + ": " + com.sk89q.util.StringUtil.joinString(args, " ");
                    if (logMode != null && player.isPlayer()) {
                        Vector position = player.getPosition();
                        LocalSession session = WorldEdit.this.getSession(player);
                        switch (logMode) {
                            case PLACEMENT: {
                                try {
                                    position = session.getPlacementPosition(player);
                                }
                                catch (IncompleteRegionException e) {
                                    break;
                                }
                            }
                            case POSITION: {
                                msg = msg + " - Position: " + position;
                                break;
                            }
                            case ALL: {
                                msg = msg + " - Position: " + position;
                            }
                            case ORIENTATION_REGION: {
                                msg = msg + " - Orientation: " + player.getCardinalDirection().name();
                            }
                            case REGION: {
                                try {
                                    msg = msg + " - Region: " + session.getSelection(player.getWorld());
                                }
                                catch (IncompleteRegionException e) {}
                                break;
                            }
                        }
                    }
                    WorldEdit.this.commandLogger.info(msg);
                }
                super.invokeMethod(parent, args, player, method, instance, methodArgs, level);
            }
        };
        this.commands.setInjector(new SimpleInjector(this));
        this.reg(BiomeCommands.class);
        this.reg(ChunkCommands.class);
        this.reg(ClipboardCommands.class);
        this.reg(GeneralCommands.class);
        this.reg(GenerationCommands.class);
        this.reg(HistoryCommands.class);
        this.reg(NavigationCommands.class);
        this.reg(RegionCommands.class);
        this.reg(ScriptingCommands.class);
        this.reg(SelectionCommands.class);
        this.reg(SnapshotUtilCommands.class);
        this.reg(ToolUtilCommands.class);
        this.reg(ToolCommands.class);
        this.reg(UtilityCommands.class);
    }

    private void reg(Class<?> clazz) {
        this.server.onCommandRegistration(this.commands.registerAndReturn(clazz), this.commands);
    }

    public static WorldEdit getInstance() {
        return instance;
    }

    public LocalSession getSession(String player) {
        return this.sessions.get(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalSession getSession(LocalPlayer player) {
        LocalSession session;
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            if (this.sessions.containsKey(player.getName())) {
                session = this.sessions.get(player.getName());
            } else {
                session = new LocalSession(this.config);
                session.setBlockChangeLimit(this.config.defaultChangeLimit);
                this.sessions.put(player.getName(), session);
            }
            int currentChangeLimit = session.getBlockChangeLimit();
            if (!player.hasPermission("worldedit.limit.unrestricted") && this.config.maxChangeLimit > -1) {
                if (this.config.defaultChangeLimit < 0) {
                    if (currentChangeLimit < 0 || currentChangeLimit > this.config.maxChangeLimit) {
                        session.setBlockChangeLimit(this.config.maxChangeLimit);
                    }
                } else {
                    int maxChangeLimit = this.config.maxChangeLimit;
                    if (currentChangeLimit == -1 || currentChangeLimit > maxChangeLimit) {
                        session.setBlockChangeLimit(maxChangeLimit);
                    }
                }
            }
            session.setUseInventory(this.config.useInventory && (!this.config.useInventoryOverride || !player.hasPermission("worldedit.inventory.unrestricted") && (!this.config.useInventoryCreativeOverride || !player.hasCreativeMode())));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSession(LocalPlayer player) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            return this.sessions.containsKey(player.getName());
        }
    }

    public BaseBlock getBlock(LocalPlayer player, String arg, boolean allAllowed) throws WorldEditException {
        return this.getBlock(player, arg, allAllowed, false);
    }

    /*
     * Unable to fully structure code
     */
    public BaseBlock getBlock(LocalPlayer player, String arg, boolean allAllowed, boolean allowNoData) throws WorldEditException {
        arg = arg.replace("_", " ");
        arg = arg.replace(";", "|");
        blockAndExtraData = arg.split("\\|");
        typeAndData = blockAndExtraData[0].split(":", 2);
        testID = typeAndData[0];
        blockId = -1;
        data = -1;
        parseDataValue = true;
        if ("hand".equalsIgnoreCase(testID)) {
            blockInHand = player.getBlockInHand();
            if (blockInHand.getClass() != BaseBlock.class) {
                return blockInHand;
            }
            blockId = blockInHand.getId();
            blockType = BlockType.fromID(blockId);
            data = blockInHand.getData();
        } else if ("pos1".equalsIgnoreCase(testID)) {
            world = player.getWorld();
            blockInHand = world.getBlock(primaryPosition = this.getSession(player).getRegionSelector(world).getPrimaryPosition());
            if (blockInHand.getClass() != BaseBlock.class) {
                return blockInHand;
            }
            blockId = blockInHand.getId();
            blockType = BlockType.fromID(blockId);
            data = blockInHand.getData();
        } else {
            block56: {
                try {
                    blockId = Integer.parseInt(testID);
                    blockType = BlockType.fromID(blockId);
                }
                catch (NumberFormatException e) {
                    blockType = BlockType.lookup(testID);
                    if (blockType != null || (t = this.server.resolveItem(testID)) <= 0) break block56;
                    blockType = BlockType.fromID(t);
                    blockId = t;
                }
            }
            if (blockId == -1 && blockType == null) {
                col = ClothColor.lookup(testID);
                if (col == null) {
                    throw new UnknownItemException(arg);
                }
                blockType = BlockType.CLOTH;
                data = col.getID();
                parseDataValue = false;
            }
            if (blockId == -1) {
                blockId = blockType.getID();
            }
            if (!player.getWorld().isValidBlockType(blockId)) {
                throw new UnknownItemException(arg);
            }
        }
        if (!allowNoData && data == -1) {
            data = 0;
        }
        if (parseDataValue) {
            try {
                if (typeAndData.length > 1 && typeAndData[1].length() > 0) {
                    data = Integer.parseInt(typeAndData[1]);
                }
                if (data > 15) {
                    throw new InvalidItemException(arg, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + typeAndData[1] + "'");
                }
                if (!(data >= 0 || allAllowed && data == -1)) {
                    data = 0;
                }
            }
            catch (NumberFormatException e) {
                if (blockType == null) {
                    throw new InvalidItemException(arg, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + typeAndData[1] + "'");
                }
                block4 : switch (2.$SwitchMap$com$sk89q$worldedit$blocks$BlockType[blockType.ordinal()]) {
                    case 9: 
                    case 10: 
                    case 11: {
                        col = ClothColor.lookup(typeAndData[1]);
                        if (col == null) {
                            throw new InvalidItemException(arg, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0446\u0432\u0435\u0442 \u043e\u0434\u0435\u0436\u0434\u044b '" + typeAndData[1] + "'");
                        }
                        data = col.getID();
                        break;
                    }
                    case 12: 
                    case 13: {
                        dataType = BlockType.lookup(typeAndData[1]);
                        if (dataType == null) {
                            throw new InvalidItemException(arg, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0442\u0443\u043f\u0435\u043d\u044c\u043a\u0438 '" + typeAndData[1] + "'");
                        }
                        switch (2.$SwitchMap$com$sk89q$worldedit$blocks$BlockType[dataType.ordinal()]) {
                            case 1: {
                                data = 0;
                                break block4;
                            }
                            case 2: {
                                data = 1;
                                break block4;
                            }
                            case 3: {
                                data = 2;
                                break block4;
                            }
                            case 4: {
                                data = 3;
                                break block4;
                            }
                            case 5: {
                                data = 4;
                                break block4;
                            }
                            case 6: {
                                data = 5;
                                break block4;
                            }
                            case 7: {
                                data = 6;
                                break block4;
                            }
                            case 8: {
                                data = 7;
                                break block4;
                            }
                        }
                        throw new InvalidItemException(arg, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0442\u0443\u043f\u0435\u043d\u044c\u043a\u0438  '" + typeAndData[1] + "'");
                    }
                    default: {
                        throw new InvalidItemException(arg, "\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 '" + typeAndData[1] + "'");
                    }
                }
            }
        }
        if (!allAllowed && !player.hasPermission("worldedit.anyblock") && this.config.disallowedBlocks.contains(blockId)) {
            throw new DisallowedItemException(arg);
        }
        if (blockType == null) {
            return new BaseBlock(blockId, data);
        }
        switch (2.$SwitchMap$com$sk89q$worldedit$blocks$BlockType[blockType.ordinal()]) {
            case 14: 
            case 15: {
                text = new String[]{blockAndExtraData.length > 1 ? blockAndExtraData[1] : "", blockAndExtraData.length > 2 ? blockAndExtraData[2] : "", blockAndExtraData.length > 3 ? blockAndExtraData[3] : "", blockAndExtraData.length > 4 ? blockAndExtraData[4] : ""};
                return new SignBlock(blockType.getID(), data, text);
            }
            case 16: {
                if (blockAndExtraData.length > 1) {
                    mobName = blockAndExtraData[1];
                    for (MobType mobType : MobType.values()) {
                        if (!mobType.getName().toLowerCase().equals(mobName.toLowerCase())) continue;
                        mobName = mobType.getName();
                        break;
                    }
                    if (!this.server.isValidMobType(mobName)) {
                        throw new InvalidItemException(arg, "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043c \u043c\u043e\u0431\u0430 '" + mobName + "'");
                    }
                    return new MobSpawnerBlock(data, mobName);
                }
                return new MobSpawnerBlock(data, MobType.PIG.getName());
            }
            case 17: {
                if (blockAndExtraData.length <= 1) {
                    return new NoteBlock(data, 0);
                }
                note = Byte.parseByte(blockAndExtraData[1]);
                if (note < 0 || note > 24) {
                    throw new InvalidItemException(arg, "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u0442\u044b \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u044b \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e: '" + blockAndExtraData[1] + "'");
                }
                return new NoteBlock(data, note);
            }
            case 18: {
                if (blockAndExtraData.length <= 1) {
                    return new SkullBlock(data);
                }
                rot = 0;
                type = "";
                try {
                    rot = Byte.parseByte(blockAndExtraData[1]);
                }
                catch (NumberFormatException e) {
                    type = blockAndExtraData[1];
                    if (blockAndExtraData.length <= 2) ** GOTO lbl142
                    try {
                        rot = Byte.parseByte(blockAndExtraData[2]);
                    }
                    catch (NumberFormatException e2) {
                        throw new InvalidItemException(arg, "\u0412\u0442\u043e\u0440\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0433\u043e\u043b\u043e\u0432\u044b \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0447\u0438\u0441\u043b\u043e\u0432\u044b\u043c.");
                    }
                }
lbl142:
                // 3 sources

                skullType = 0;
                if (!type.isEmpty()) {
                    skullType = type.equalsIgnoreCase("skeleton") != false ? 0 : (type.equalsIgnoreCase("wither") != false ? 1 : (type.equalsIgnoreCase("zombie") != false ? 2 : (type.equalsIgnoreCase("creeper") != false ? 4 : 3)));
                }
                if (skullType == 3) {
                    return new SkullBlock(data, rot, type.replace(" ", "_"));
                }
                return new SkullBlock(data, (byte)skullType, rot);
            }
        }
        return new BaseBlock(blockId, data);
    }

    public BaseBlock getBlock(LocalPlayer player, String id) throws WorldEditException {
        return this.getBlock(player, id, false);
    }

    public Set<BaseBlock> getBlocks(LocalPlayer player, String list, boolean allAllowed, boolean allowNoData) throws WorldEditException {
        String[] items = list.split(",");
        HashSet<BaseBlock> blocks = new HashSet<BaseBlock>();
        for (String id : items) {
            blocks.add(this.getBlock(player, id, allAllowed, allowNoData));
        }
        return blocks;
    }

    public Set<BaseBlock> getBlocks(LocalPlayer player, String list, boolean allAllowed) throws WorldEditException {
        return this.getBlocks(player, list, allAllowed, false);
    }

    public Set<BaseBlock> getBlocks(LocalPlayer player, String list) throws WorldEditException {
        return this.getBlocks(player, list, false);
    }

    public Pattern getBlockPattern(LocalPlayer player, String patternString) throws WorldEditException {
        String[] items = patternString.split(",");
        if (patternString.charAt(0) == '#') {
            if (!patternString.equals("#clipboard") && !patternString.equals("#copy")) {
                throw new UnknownItemException(patternString);
            }
            LocalSession session = this.getSession(player);
            try {
                return new ClipboardPattern(session.getClipboard());
            }
            catch (EmptyClipboardException e) {
                player.printError("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0441\u043a\u043e\u043f\u0438\u0440\u0443\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e //copy.");
                throw new UnknownItemException("#clipboard");
            }
        }
        if (items.length == 1) {
            return new SingleBlockPattern(this.getBlock(player, items[0]));
        }
        ArrayList<BlockChance> blockChances = new ArrayList<BlockChance>();
        for (String s : items) {
            BaseBlock block;
            double chance;
            if (s.matches("[0-9]+(\\.[0-9]*)?%.*")) {
                String[] p = s.split("%");
                chance = Double.parseDouble(p[0]);
                block = this.getBlock(player, p[1]);
            } else {
                chance = 1.0;
                block = this.getBlock(player, s);
            }
            blockChances.add(new BlockChance(block, chance));
        }
        return new RandomFillPattern(blockChances);
    }

    public Mask getBlockMask(LocalPlayer player, LocalSession session, String maskString) throws WorldEditException {
        ArrayList<Mask> masks = new ArrayList<Mask>();
        for (String component : maskString.split(" ")) {
            if (component.length() == 0) continue;
            Mask current = this.getBlockMaskComponent(player, session, masks, component);
            masks.add(current);
        }
        switch (masks.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Mask)masks.get(0);
            }
        }
        return new CombinedMask(masks);
    }

    private Mask getBlockMaskComponent(LocalPlayer player, LocalSession session, List<Mask> masks, String component) throws WorldEditException {
        char firstChar = component.charAt(0);
        switch (firstChar) {
            case '#': {
                if (component.equalsIgnoreCase("#existing")) {
                    return new ExistingBlockMask();
                }
                if (component.equalsIgnoreCase("#solid")) {
                    return new SolidBlockMask();
                }
                if (component.equalsIgnoreCase("#dregion") || component.equalsIgnoreCase("#dselection") || component.equalsIgnoreCase("#dsel")) {
                    return new DynamicRegionMask();
                }
                if (component.equalsIgnoreCase("#selection") || component.equalsIgnoreCase("#region") || component.equalsIgnoreCase("#sel")) {
                    return new RegionMask(session.getSelection(player.getWorld()));
                }
                throw new UnknownItemException(component);
            }
            case '<': 
            case '>': {
                Mask submask = component.length() > 1 ? this.getBlockMaskComponent(player, session, masks, component.substring(1)) : new ExistingBlockMask();
                return new UnderOverlayMask(submask, firstChar == '>');
            }
            case '$': {
                String[] biomesList;
                HashSet<BiomeType> biomes = new HashSet<BiomeType>();
                for (String biomeName : biomesList = component.substring(1).split(",")) {
                    BiomeType biome = this.server.getBiomes().get(biomeName);
                    biomes.add(biome);
                }
                return new BiomeTypeMask(biomes);
            }
            case '%': {
                int i = Integer.parseInt(component.substring(1));
                return new RandomMask((double)i / 100.0);
            }
            case '!': {
                if (component.length() <= 1) break;
                return new InvertedMask(this.getBlockMaskComponent(player, session, masks, component.substring(1)));
            }
        }
        return new BlockMask(this.getBlocks(player, component, true, true));
    }

    public Set<Integer> getBlockIDs(LocalPlayer player, String list, boolean allBlocksAllowed) throws WorldEditException {
        String[] items = list.split(",");
        HashSet<Integer> blocks = new HashSet<Integer>();
        for (String s : items) {
            blocks.add(this.getBlock(player, s, allBlocksAllowed).getType());
        }
        return blocks;
    }

    public File getSafeSaveFile(LocalPlayer player, File dir, String filename, String defaultExt, String ... extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, true);
    }

    public File getSafeOpenFile(LocalPlayer player, File dir, String filename, String defaultExt, String ... extensions) throws FilenameException {
        return this.getSafeFile(player, dir, filename, defaultExt, extensions, false);
    }

    private File getSafeFile(LocalPlayer player, File dir, String filename, String defaultExt, String[] extensions, boolean isSave) throws FilenameException {
        File f;
        if (extensions != null && extensions.length == 1 && extensions[0] == null) {
            extensions = null;
        }
        if (filename.equals("#")) {
            f = isSave ? player.openFileSaveDialog(extensions) : player.openFileOpenDialog(extensions);
            if (f == null) {
                throw new FileSelectionAbortedException("\u0424\u0430\u0439\u043b \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d");
            }
        } else {
            if (defaultExt != null && filename.lastIndexOf(46) == -1) {
                filename = filename + "." + defaultExt;
            }
            if (!filename.matches("^[A-Za-z0-9_\\- \\./\\\\'\\$@~!%\\^\\*\\(\\)\\[\\]\\+\\{\\},\\?]+\\.[A-Za-z0-9]+$")) {
                throw new InvalidFilenameException(filename, "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b \u0432 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0438 \u0438\u043b\u0438 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435");
            }
            f = new File(dir, filename);
        }
        try {
            String filePath = f.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath) && !this.config.allowSymlinks) {
                throw new FilenameResolutionException(filename, "\u041f\u0430\u043f\u043a\u0430 \u0437\u0430 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u043c\u0438 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0433\u043e \u043a\u043e\u0440\u043d\u044f");
            }
            return f;
        }
        catch (IOException e) {
            throw new FilenameResolutionException(filename, "\u041f\u0430\u043f\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
    }

    public int getMaximumPolygonalPoints(LocalPlayer player) {
        if (player.hasPermission("worldedit.limit.unrestricted") || this.config.maxPolygonalPoints < 0) {
            return this.config.defaultMaxPolygonalPoints;
        }
        if (this.config.defaultMaxPolygonalPoints < 0) {
            return this.config.maxPolygonalPoints;
        }
        return Math.min(this.config.defaultMaxPolygonalPoints, this.config.maxPolygonalPoints);
    }

    public int getMaximumPolyhedronPoints(LocalPlayer player) {
        if (player.hasPermission("worldedit.limit.unrestricted") || this.config.maxPolyhedronPoints < 0) {
            return this.config.defaultMaxPolyhedronPoints;
        }
        if (this.config.defaultMaxPolyhedronPoints < 0) {
            return this.config.maxPolyhedronPoints;
        }
        return Math.min(this.config.defaultMaxPolyhedronPoints, this.config.maxPolyhedronPoints);
    }

    public void checkMaxRadius(double radius) throws MaxRadiusException {
        if (this.config.maxRadius > 0 && radius > (double)this.config.maxRadius) {
            throw new MaxRadiusException();
        }
    }

    public void checkMaxBrushRadius(double radius) throws MaxBrushRadiusException {
        if (this.config.maxBrushRadius > 0 && radius > (double)this.config.maxBrushRadius) {
            throw new MaxBrushRadiusException();
        }
    }

    public File getWorkingDirectoryFile(String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(this.config.getWorkingDirectory(), path);
    }

    public static int divisorMod(int a, int n) {
        return (int)((double)a - (double)n * Math.floor(Math.floor(a) / (double)n));
    }

    public Vector getDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        dirStr = dirStr.toLowerCase();
        PlayerDirection dir = this.getPlayerDirection(player, dirStr);
        switch (dir) {
            case WEST: 
            case EAST: 
            case SOUTH: 
            case NORTH: 
            case UP: 
            case DOWN: {
                return dir.vector();
            }
        }
        throw new UnknownDirectionException(dir.name());
    }

    private PlayerDirection getPlayerDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        PlayerDirection dir;
        switch (dirStr.charAt(0)) {
            case 'w': {
                dir = PlayerDirection.WEST;
                break;
            }
            case 'e': {
                dir = PlayerDirection.EAST;
                break;
            }
            case 's': {
                if (dirStr.indexOf(119) > 0) {
                    return PlayerDirection.SOUTH_WEST;
                }
                if (dirStr.indexOf(101) > 0) {
                    return PlayerDirection.SOUTH_EAST;
                }
                dir = PlayerDirection.SOUTH;
                break;
            }
            case 'n': {
                if (dirStr.indexOf(119) > 0) {
                    return PlayerDirection.NORTH_WEST;
                }
                if (dirStr.indexOf(101) > 0) {
                    return PlayerDirection.NORTH_EAST;
                }
                dir = PlayerDirection.NORTH;
                break;
            }
            case 'u': {
                dir = PlayerDirection.UP;
                break;
            }
            case 'd': {
                dir = PlayerDirection.DOWN;
                break;
            }
            case 'f': 
            case 'm': {
                dir = player.getCardinalDirection(0);
                break;
            }
            case 'b': {
                dir = player.getCardinalDirection(180);
                break;
            }
            case 'l': {
                dir = player.getCardinalDirection(-90);
                break;
            }
            case 'r': {
                dir = player.getCardinalDirection(90);
                break;
            }
            default: {
                throw new UnknownDirectionException(dirStr);
            }
        }
        return dir;
    }

    public Vector getDiagonalDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        return this.getPlayerDirection(player, dirStr.toLowerCase()).vector();
    }

    public CuboidClipboard.FlipDirection getFlipDirection(LocalPlayer player, String dirStr) throws UnknownDirectionException {
        PlayerDirection dir = this.getPlayerDirection(player, dirStr);
        switch (dir) {
            case WEST: 
            case EAST: {
                return CuboidClipboard.FlipDirection.WEST_EAST;
            }
            case SOUTH: 
            case NORTH: {
                return CuboidClipboard.FlipDirection.NORTH_SOUTH;
            }
            case UP: 
            case DOWN: {
                return CuboidClipboard.FlipDirection.UP_DOWN;
            }
        }
        throw new UnknownDirectionException(dir.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(LocalPlayer player) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.remove(player.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSessions() {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.clear();
        }
    }

    public void flushBlockBag(LocalPlayer player, EditSession editSession) {
        Map<Integer, Integer> missingBlocks;
        BlockBag blockBag = editSession.getBlockBag();
        if (blockBag != null) {
            blockBag.flushChanges();
        }
        if ((missingBlocks = editSession.popMissingBlocks()).size() > 0) {
            StringBuilder str = new StringBuilder();
            str.append("\u0414\u0430\u043d\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438 \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u044b: ");
            int size = missingBlocks.size();
            int i = 0;
            for (Integer id : missingBlocks.keySet()) {
                BlockType type = BlockType.fromID(id);
                str.append(type != null ? type.getName() + " (" + id + ")" : id.toString());
                str.append(" [\u041a\u043e\u043b.: " + missingBlocks.get(id) + "]");
                if (++i == size) continue;
                str.append(", ");
            }
            player.printError(str.toString());
        }
    }

    public Map<String, String> getCommands() {
        return this.commands.getCommands();
    }

    public CommandsManager<LocalPlayer> getCommandsManager() {
        return this.commands;
    }

    @Deprecated
    public void handleDisconnect(LocalPlayer player) {
        this.forgetPlayer(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markExpire(LocalPlayer player) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            LocalSession session = this.sessions.get(player.getName());
            if (session != null) {
                session.update();
            }
        }
    }

    public void forgetPlayer(LocalPlayer player) {
        this.removeSession(player);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushExpiredSessions(SessionCheck checker) {
        HashMap<String, LocalSession> hashMap = this.sessions;
        synchronized (hashMap) {
            Iterator<Map.Entry<String, LocalSession>> it = this.sessions.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, LocalSession> entry = it.next();
                if (!entry.getValue().hasExpired() || checker.isOnlinePlayer(entry.getKey())) continue;
                it.remove();
            }
        }
    }

    public boolean handleArmSwing(LocalPlayer player) {
        if (player.getItemInHand() == this.config.navigationWand) {
            if (this.config.navigationWandMaxDistance <= 0) {
                return false;
            }
            if (!player.hasPermission("worldedit.navigation.jumpto.tool")) {
                return false;
            }
            WorldVector pos = player.getSolidBlockTrace(this.config.navigationWandMaxDistance);
            if (pos != null) {
                player.findFreePosition(pos);
            } else {
                player.printError("\u041d\u0430 \u0443\u043a\u0430\u0437\u0430\u0442\u0435\u043b\u0435 \u043d\u0435\u0442 \u0431\u043b\u043e\u043a\u0430 (\u0438\u043b\u0438 \u043e\u043d \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0434\u0430\u043b\u0435\u043a\u043e)!");
            }
            return true;
        }
        LocalSession session = this.getSession(player);
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof DoubleActionTraceTool && tool.canUse(player)) {
            ((DoubleActionTraceTool)tool).actSecondary(this.server, this.config, player, session);
            return true;
        }
        return false;
    }

    public boolean handleRightClick(LocalPlayer player) {
        if (player.getItemInHand() == this.config.navigationWand) {
            if (this.config.navigationWandMaxDistance <= 0) {
                return false;
            }
            if (!player.hasPermission("worldedit.navigation.thru.tool")) {
                return false;
            }
            if (!player.passThroughForwardWall(40)) {
                player.printError("\u0422\u0430\u043c \u043d\u0438\u0447\u0435\u0433\u043e \u043d\u0435\u0442!");
            }
            return true;
        }
        LocalSession session = this.getSession(player);
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof TraceTool && tool.canUse(player)) {
            ((TraceTool)tool).actPrimary(this.server, this.config, player, session);
            return true;
        }
        return false;
    }

    public boolean handleBlockRightClick(LocalPlayer player, WorldVector clicked) {
        LocalSession session = this.getSession(player);
        if (player.getItemInHand() == this.config.wandItem) {
            if (!session.isToolControlEnabled()) {
                return false;
            }
            if (!player.hasPermission("worldedit.selection.pos")) {
                return false;
            }
            RegionSelector selector = session.getRegionSelector(player.getWorld());
            if (selector.selectSecondary(clicked)) {
                selector.explainSecondarySelection(player, session, clicked);
            }
            return true;
        }
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof BlockTool && tool.canUse(player)) {
            ((BlockTool)tool).actPrimary(this.server, this.config, player, session, clicked);
            return true;
        }
        return false;
    }

    public boolean handleBlockLeftClick(LocalPlayer player, WorldVector clicked) {
        BlockTool superPickaxe;
        LocalSession session = this.getSession(player);
        if (player.getItemInHand() == this.config.wandItem) {
            if (!session.isToolControlEnabled()) {
                return false;
            }
            if (!player.hasPermission("worldedit.selection.pos")) {
                return false;
            }
            RegionSelector selector = session.getRegionSelector(player.getWorld());
            if (selector.selectPrimary(clicked)) {
                selector.explainPrimarySelection(player, session, clicked);
            }
            return true;
        }
        if (player.isHoldingPickAxe() && session.hasSuperPickAxe() && (superPickaxe = session.getSuperPickaxe()) != null && superPickaxe.canUse(player)) {
            return superPickaxe.actPrimary(this.server, this.config, player, session, clicked);
        }
        Tool tool = session.getTool(player.getItemInHand());
        if (tool != null && tool instanceof DoubleActionBlockTool && tool.canUse(player)) {
            ((DoubleActionBlockTool)tool).actSecondary(this.server, this.config, player, session, clicked);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleCommand(LocalPlayer player, String[] split) {
        try {
            split = this.commandDetection(split);
            if (!this.commands.hasCommand(split[0])) {
                return false;
            }
            LocalSession session = this.getSession(player);
            EditSession editSession = session.createEditSession(player);
            editSession.enableQueue();
            session.tellVersion(player);
            long start = System.currentTimeMillis();
            try {
                this.commands.execute(split, player, session, player, editSession);
                return true;
            }
            catch (CommandPermissionsException e) {
                player.printError("\u0423 \u0412\u0430\u0441 \u043d\u0435 \u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u043f\u0440\u0430\u0432 \u043d\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.");
                return true;
            }
            catch (MissingNestedCommandException e) {
                player.printError(e.getUsage());
                return true;
            }
            catch (CommandUsageException e) {
                player.printError(e.getMessage());
                player.printError(e.getUsage());
                return true;
            }
            catch (PlayerNeededException e) {
                player.printError(e.getMessage());
                return true;
            }
            catch (WrappedCommandException e) {
                throw e.getCause();
            }
            catch (UnhandledCommandException e) {
                player.printError("Command could not be handled; invalid sender!");
                boolean bl = false;
                return bl;
            }
            finally {
                session.remember(editSession);
                editSession.flushQueue();
                if (this.config.profile) {
                    long time = System.currentTimeMillis() - start;
                    int changed = editSession.getBlockChangeCount();
                    if (time > 0L) {
                        double throughput = (double)changed / ((double)time / 1000.0);
                        player.printDebug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0437\u0430 " + (double)time / 1000.0 + " " + StringUtil.plural(Integer.parseInt((double)time / 1000.0 + ""), "\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434") + " (\u0438\u0441\u0442\u043e\u0440\u0438\u044f: " + changed + " \u0438\u0437\u043c\u0435\u043d\u0435\u043d; " + Math.round(throughput) + " " + StringUtil.plural(Integer.parseInt(Math.round(throughput) + ""), "\u0431\u043b\u043e\u043a", "\u0431\u043b\u043e\u043a\u0430", "\u0431\u043b\u043e\u043a\u043e\u0432") + "/\u0441\u0435\u043a).");
                    } else {
                        player.printDebug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0437\u0430 " + StringUtil.plural(Integer.parseInt((double)time / 1000.0 + ""), "\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434") + "s elapsed.");
                    }
                }
                this.flushBlockBag(player, editSession);
            }
        }
        catch (NumberFormatException e) {
            Matcher matcher = numberFormatExceptionPattern.matcher(e.getMessage());
            if (matcher.matches()) {
                player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440; \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0430 \"" + matcher.group(1) + "\".");
                return true;
            }
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440; \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0430.");
            return true;
        }
        catch (IncompleteRegionException e) {
            player.printError("\u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0432\u044b\u0434\u0435\u043b\u0438\u0442\u0435 \u0440\u0435\u0433\u0438\u043e\u043d.");
            return true;
        }
        catch (UnknownItemException e) {
            player.printError("\u0411\u043b\u043e\u043a \u0441 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c '" + e.getID() + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
            return true;
        }
        catch (InvalidItemException e) {
            player.printError(e.getMessage());
            return true;
        }
        catch (DisallowedItemException e) {
            player.printError("\u0411\u043b\u043e\u043a\u0430 '" + e.getID() + "' \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d (\u0441\u043c\u043e\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e WorldEdit).");
            return true;
        }
        catch (MaxChangedBlocksException e) {
            player.printError("\u0412\u044b \u043f\u044b\u0442\u0430\u0435\u0442\u0435\u0441\u044c \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0431\u043b\u043e\u043a\u043e\u0432 \u0437\u0430 \u043e\u0434\u043d\u0443 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044e (" + e.getBlockLimit() + ").");
            return true;
        }
        catch (MaxBrushRadiusException e) {
            player.printError("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440 \u043a\u0438\u0441\u0442\u0438: " + this.config.maxBrushRadius);
            return true;
        }
        catch (MaxRadiusException e) {
            player.printError("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: " + this.config.maxRadius);
            return true;
        }
        catch (UnknownDirectionException e) {
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: " + e.getDirection());
            return true;
        }
        catch (InsufficientArgumentsException e) {
            player.printError(e.getMessage());
            return true;
        }
        catch (EmptyClipboardException e) {
            player.printError("\u0412\u0430\u0448 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430 \u043f\u0443\u0441\u0442. \u0421\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 //copy.");
            return true;
        }
        catch (InvalidFilenameException e) {
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u043e\u0435 \u0438\u043c\u044f \u0444\u0430\u0439\u043b\u0430 '" + e.getFilename() + "': " + e.getMessage());
            return true;
        }
        catch (FilenameResolutionException e) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0440\u0435\u0437\u043e\u043b\u044e\u0446\u0438\u0438 \u0444\u0430\u0439\u043b\u0430 '" + e.getFilename() + "': " + e.getMessage());
            return true;
        }
        catch (InvalidToolBindException e) {
            player.printError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 \u043a \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0443 " + ItemType.toHeldName(e.getItemId()) + ": " + e.getMessage());
            return true;
        }
        catch (FileSelectionAbortedException e) {
            player.printError("\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
            return true;
        }
        catch (WorldEditException e) {
            player.printError(e.getMessage());
            return true;
        }
        catch (Throwable excp) {
            player.printError("\u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0443, \u0441\u043e\u043e\u0431\u0449\u0438\u0442\u0435 \u043e\u0431 \u043e\u0448\u0438\u0431\u043a\u0435: [\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0441\u043e\u043b\u044c]");
            player.printRaw(excp.getClass().getName() + ": " + excp.getMessage());
            excp.printStackTrace();
        }
        return true;
    }

    public String[] commandDetection(String[] split) {
        String searchCmd;
        split[0] = split[0].substring(1);
        if (split[0].matches("^[^/].*\\.js$")) {
            String[] newSplit = new String[split.length + 1];
            System.arraycopy(split, 0, newSplit, 1, split.length);
            newSplit[0] = "cs";
            newSplit[1] = newSplit[1];
            split = newSplit;
        }
        if (!this.commands.hasCommand(searchCmd = split[0].toLowerCase())) {
            if (this.config.noDoubleSlash && this.commands.hasCommand("/" + searchCmd)) {
                split[0] = "/" + split[0];
            } else if (split[0].length() >= 2 && split[0].charAt(0) == '/' && this.commands.hasCommand(searchCmd.substring(1))) {
                split[0] = split[0].substring(1);
            }
        }
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(LocalPlayer player, File f, String[] args) throws WorldEditException {
        String script;
        int index;
        String filename = f.getPath();
        String ext = filename.substring((index = filename.lastIndexOf(".")) + 1, filename.length());
        if (!ext.equalsIgnoreCase("js")) {
            player.printError("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u0444\u0430\u0439\u043b\u044b \u0441 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435\u043c .js");
            return;
        }
        try {
            InputStream file;
            if (!f.exists()) {
                file = WorldEdit.class.getResourceAsStream("craftscripts/" + filename);
                if (file == null) {
                    player.printError("\u0421\u043a\u0440\u0438\u043f\u0442 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442: " + filename);
                    return;
                }
            } else {
                file = new FileInputStream(f);
            }
            DataInputStream in2 = new DataInputStream(file);
            byte[] data = new byte[in2.available()];
            in2.readFully(data);
            in2.close();
            script = new String(data, 0, data.length, "utf-8");
        }
        catch (IOException e) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f \u0441\u043a\u0440\u0438\u043f\u0442\u0430: " + e.getMessage());
            return;
        }
        LocalSession session = this.getSession(player);
        CraftScriptContext scriptContext = new CraftScriptContext(this, this.server, this.config, session, player, args);
        RhinoCraftScriptEngine engine = null;
        try {
            engine = new RhinoCraftScriptEngine();
        }
        catch (NoClassDefFoundError e) {
            player.printError("\u0421\u0438\u0441\u0442\u0435\u043c\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
            player.printError("\u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0438\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u044e \u043d\u0430 http://wiki.sk89q.com/wiki/WorldEdit/Installation");
            return;
        }
        engine.setTimeLimit(this.config.scriptTimeout);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("argv", args);
        vars.put("context", scriptContext);
        vars.put("player", player);
        try {
            engine.evaluate(script, filename, vars);
        }
        catch (ScriptException e) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f:");
            player.printRaw(e.getMessage());
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (WorldEditException e) {
            throw e;
        }
        catch (Throwable e) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f (\u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0441\u043e\u043b\u044c):");
            player.printRaw(e.getClass().getCanonicalName());
            e.printStackTrace();
        }
        finally {
            for (EditSession editSession : scriptContext.getEditSessions()) {
                editSession.flushQueue();
                session.remember(editSession);
            }
        }
    }

    public LocalConfiguration getConfiguration() {
        return this.config;
    }

    public ServerInterface getServer() {
        return this.server;
    }

    public EditSessionFactory getEditSessionFactory() {
        return this.editSessionFactory;
    }

    public void setEditSessionFactory(EditSessionFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("New EditSessionFactory may not be null");
        }
        logger.info("Accepted EditSessionFactory of type " + factory.getClass().getName() + " from " + factory.getClass().getPackage().getName());
        this.editSessionFactory = factory;
    }

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        Package p = WorldEdit.class.getPackage();
        if (p == null) {
            p = Package.getPackage("com.sk89q.worldedit");
        }
        if (p == null) {
            version = "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f)";
        } else {
            version = p.getImplementationVersion();
            if (version == null) {
                version = "(\u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f)";
            }
        }
        return version;
    }

    public static void setVersion(String version) {
        WorldEdit.version = version;
    }

    static {
        WorldEdit.getVersion();
        numberFormatExceptionPattern = java.util.regex.Pattern.compile("^For input string: \"(.*)\"$");
    }
}

