/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ClothColor {
    WHITE(0, "\u0411\u0435\u043b\u044b\u0439", "white"),
    ORANGE(1, "\u041e\u0440\u0430\u043d\u0436\u0435\u0432\u044b\u0439", "orange"),
    MAGENTA(2, "\u041f\u0443\u0440\u043f\u0443\u0440\u043d\u044b\u0439", "magenta"),
    LIGHT_BLUE(3, "\u0421\u0432\u0435\u0442\u043b\u043e-\u0441\u0438\u043d\u0438\u0439", "lightblue"),
    YELLOW(4, "\u0416\u0435\u043b\u0442\u044b\u0439", "yellow"),
    LIGHT_GREEN(5, "\u0421\u0432\u0435\u0442\u043b\u043e-\u0437\u0435\u043b\u0435\u043d\u044b\u0439", "lightgreen"),
    PINK(6, "\u0420\u043e\u0437\u043e\u0432\u044b\u0439", new String[]{"pink", "lightred"}),
    GRAY(7, "\u0421\u0435\u0440\u0432\u044b\u0439", new String[]{"grey", "gray"}),
    LIGHT_GRAY(8, "\u0421\u0432\u043a\u0442\u043b\u043e-\u0441\u0438\u043d\u0438\u0439", new String[]{"lightgrey", "lightgray"}),
    CYAN(9, "\u0413\u043e\u043b\u0443\u0431\u043e\u0439", new String[]{"cyan", "turquoise"}),
    PURPLE(10, "\u0424\u0438\u043e\u043b\u0435\u0442\u043e\u0432\u044b\u0439", new String[]{"purple", "violet"}),
    BLUE(11, "\u0421\u0438\u043d\u0438\u0439", "blue"),
    BROWN(12, "\u041a\u043e\u0440\u0438\u0447\u043d\u0435\u0432\u044b\u0439", new String[]{"brown", "cocoa", "coffee"}),
    DARK_GREEN(13, "\u0422\u0435\u043c\u043d\u043e-\u0441\u0438\u043d\u0438\u0439", new String[]{"green", "darkgreen", "cactusgreen", "cactigreen"}),
    RED(14, "\u041a\u0440\u0430\u0441\u043d\u044b\u0439", "red"),
    BLACK(15, "\u0427\u0435\u0440\u043d\u044b\u0439", "black");

    private static final Map<Integer, ClothColor> ids;
    private static final Map<String, ClothColor> lookup;
    private final int id;
    private final String name;
    private final String[] lookupKeys;

    private ClothColor(int id, String name, String lookupKey) {
        this.id = id;
        this.name = name;
        this.lookupKeys = new String[]{lookupKey};
    }

    private ClothColor(int id, String name, String[] lookupKeys) {
        this.id = id;
        this.name = name;
        this.lookupKeys = lookupKeys;
    }

    public static ClothColor fromID(int id) {
        return ids.get(id);
    }

    public static ClothColor lookup(String name) {
        return lookup.get(name.toLowerCase());
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    static {
        ids = new HashMap<Integer, ClothColor>();
        lookup = new HashMap<String, ClothColor>();
        for (ClothColor type : EnumSet.allOf(ClothColor.class)) {
            ids.put(type.id, type);
            for (String key : type.lookupKeys) {
                lookup.put(key, type);
            }
        }
    }

    public static final class ID {
        public static final int WHITE = 0;
        public static final int ORANGE = 1;
        public static final int MAGENTA = 2;
        public static final int LIGHT_BLUE = 3;
        public static final int YELLOW = 4;
        public static final int LIGHT_GREEN = 5;
        public static final int PINK = 6;
        public static final int GRAY = 7;
        public static final int LIGHT_GRAY = 8;
        public static final int CYAN = 9;
        public static final int PURPLE = 10;
        public static final int BLUE = 11;
        public static final int BROWN = 12;
        public static final int DARK_GREEN = 13;
        public static final int RED = 14;
        public static final int BLACK = 15;
    }
}

