/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit;

import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.LocalEntity;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.blocks.ContainerBlock;
import com.sk89q.worldedit.blocks.FurnaceBlock;
import com.sk89q.worldedit.blocks.MobSpawnerBlock;
import com.sk89q.worldedit.blocks.SignBlock;
import com.sk89q.worldedit.blocks.SkullBlock;
import com.sk89q.worldedit.bukkit.BukkitBiomeType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.EditSessionBlockChangeDelegate;
import com.sk89q.worldedit.bukkit.NmsBlock;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.entity.BukkitEntity;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.TreeGenerator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Furnace;
import org.bukkit.block.NoteBlock;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BukkitWorld
extends LocalWorld {
    private static final Logger logger = WorldEdit.logger;
    private World world;
    private static boolean skipNmsAccess = false;
    private static boolean skipNmsSafeSet = false;
    private static boolean skipNmsValidBlockCheck = false;
    private static Class<? extends NmsBlock> nmsBlockType;
    private static Method nmsSetMethod;
    private static Method nmsValidBlockMethod;
    private static Method nmsGetMethod;
    private static Method nmsSetSafeMethod;
    private static org.bukkit.entity.EntityType tntMinecartType;
    private static boolean checkMinecartType;
    private static final EnumMap<TreeGenerator.TreeType, TreeType> treeTypeMapping;
    private static final Map<Integer, Effect> effects;

    private static <T extends Enum<T>> T tryEnum(Class<T> enumType, String ... values) {
        for (String val : values) {
            try {
                return Enum.valueOf(enumType, val);
            }
            catch (IllegalArgumentException e) {
            }
        }
        return null;
    }

    public BukkitWorld(World world) {
        block15: {
            this.world = world;
            if (checkMinecartType) {
                tntMinecartType = BukkitWorld.tryEnum(org.bukkit.entity.EntityType.class, "MINECART_TNT");
                checkMinecartType = false;
            }
            if (nmsBlockType != null || skipNmsAccess || skipNmsSafeSet || skipNmsValidBlockCheck) {
                return;
            }
            Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldEdit");
            if (!(plugin instanceof WorldEditPlugin)) {
                return;
            }
            WorldEditPlugin wePlugin = (WorldEditPlugin)plugin;
            File nmsBlocksDir = new File(wePlugin.getDataFolder() + File.separator + "nmsblocks" + File.separator);
            if (nmsBlocksDir.listFiles() == null) {
                skipNmsAccess = true;
                skipNmsSafeSet = true;
                skipNmsValidBlockCheck = true;
                return;
            }
            try {
                NmsBlockClassLoader loader = new NmsBlockClassLoader(BukkitWorld.class.getClassLoader(), nmsBlocksDir);
                for (File f : nmsBlocksDir.listFiles()) {
                    if (!f.isFile()) continue;
                    String filename = f.getName();
                    Class<?> testBlock = null;
                    try {
                        testBlock = loader.loadClass("CL-NMS" + filename);
                    }
                    catch (Throwable e) {
                        continue;
                    }
                    filename = filename.replaceFirst(".class$", "");
                    if (!NmsBlock.class.isAssignableFrom(testBlock)) continue;
                    Class<?> nmsClass = testBlock;
                    boolean canUse = false;
                    try {
                        canUse = (Boolean)nmsClass.getMethod("verify", new Class[0]).invoke(null, new Object[0]);
                    }
                    catch (Throwable e) {
                        continue;
                    }
                    if (!canUse) continue;
                    nmsBlockType = nmsClass;
                    nmsSetMethod = nmsBlockType.getMethod("set", World.class, Vector.class, BaseBlock.class);
                    nmsValidBlockMethod = nmsBlockType.getMethod("isValidBlockType", Integer.TYPE);
                    nmsGetMethod = nmsBlockType.getMethod("get", World.class, Vector.class, Integer.TYPE, Integer.TYPE);
                    nmsSetSafeMethod = nmsBlockType.getMethod("setSafely", BukkitWorld.class, Vector.class, com.sk89q.worldedit.foundation.Block.class, Boolean.TYPE);
                    break;
                }
                if (nmsBlockType != null) {
                    logger.info("[WorldEdit] Using external NmsBlock for this version: " + nmsBlockType.getName());
                    break block15;
                }
                try {
                    nmsBlockType = Class.forName("com.sk89q.worldedit.bukkit.DefaultNmsBlock");
                    boolean canUse = (Boolean)nmsBlockType.getMethod("verify", new Class[0]).invoke(null, new Object[0]);
                    if (canUse) {
                        nmsSetMethod = nmsBlockType.getMethod("set", World.class, Vector.class, BaseBlock.class);
                        nmsValidBlockMethod = nmsBlockType.getMethod("isValidBlockType", Integer.TYPE);
                        nmsGetMethod = nmsBlockType.getMethod("get", World.class, Vector.class, Integer.TYPE, Integer.TYPE);
                        nmsSetSafeMethod = nmsBlockType.getMethod("setSafely", BukkitWorld.class, Vector.class, com.sk89q.worldedit.foundation.Block.class, Boolean.TYPE);
                        logger.info("[WorldEdit] Using inbuilt NmsBlock for this version.");
                    }
                }
                catch (Throwable e) {
                    skipNmsAccess = true;
                    skipNmsSafeSet = true;
                    skipNmsValidBlockCheck = true;
                    logger.warning("[WorldEdit] No compatible nms block class found.");
                }
            }
            catch (Throwable e) {
                logger.warning("[WorldEdit] Unable to load NmsBlock classes, make sure they are installed correctly.");
                e.printStackTrace();
                skipNmsAccess = true;
                skipNmsSafeSet = true;
                skipNmsValidBlockCheck = true;
            }
        }
    }

    public World getWorld() {
        return this.world;
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public boolean setBlockType(Vector pt, int type) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setTypeId(type);
    }

    @Override
    public boolean setBlockTypeFast(Vector pt, int type) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setTypeId(type, false);
    }

    @Override
    public boolean setTypeIdAndData(Vector pt, int type, int data) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setTypeIdAndData(type, (byte)data, true);
    }

    @Override
    public boolean setTypeIdAndDataFast(Vector pt, int type, int data) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setTypeIdAndData(type, (byte)data, false);
    }

    @Override
    public int getBlockType(Vector pt) {
        return this.world.getBlockTypeIdAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
    }

    @Override
    public void setBlockData(Vector pt, int data) {
        this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setData((byte)data);
    }

    @Override
    public void setBlockDataFast(Vector pt, int data) {
        this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).setData((byte)data, false);
    }

    @Override
    public int getBlockData(Vector pt) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).getData();
    }

    @Override
    public int getBlockLightLevel(Vector pt) {
        return this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).getLightLevel();
    }

    @Override
    public BiomeType getBiome(Vector2D pt) {
        Biome bukkitBiome = this.world.getBiome(pt.getBlockX(), pt.getBlockZ());
        try {
            return BukkitBiomeType.valueOf(bukkitBiome.name());
        }
        catch (IllegalArgumentException exc) {
            return BiomeType.UNKNOWN;
        }
    }

    @Override
    public void setBiome(Vector2D pt, BiomeType biome) {
        if (biome instanceof BukkitBiomeType) {
            Biome bukkitBiome = ((BukkitBiomeType)biome).getBukkitBiome();
            this.world.setBiome(pt.getBlockX(), pt.getBlockZ(), bukkitBiome);
        }
    }

    @Override
    public boolean regenerate(Region region, EditSession editSession) {
        BaseBlock[] history = new BaseBlock[256 * (this.getMaxY() + 1)];
        for (Vector2D chunk : region.getChunks()) {
            int index;
            Vector pt;
            int z;
            int y;
            int x;
            Vector min = new Vector(chunk.getBlockX() * 16, 0, chunk.getBlockZ() * 16);
            for (x = 0; x < 16; ++x) {
                for (y = 0; y < this.getMaxY() + 1; ++y) {
                    for (z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        index = y * 16 * 16 + z * 16 + x;
                        history[index] = editSession.getBlock(pt);
                    }
                }
            }
            try {
                this.world.regenerateChunk(chunk.getBlockX(), chunk.getBlockZ());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            for (x = 0; x < 16; ++x) {
                for (y = 0; y < this.getMaxY() + 1; ++y) {
                    for (z = 0; z < 16; ++z) {
                        pt = min.add(x, y, z);
                        index = y * 16 * 16 + z * 16 + x;
                        if (!region.contains(pt)) {
                            editSession.smartSetBlock(pt, history[index]);
                            continue;
                        }
                        editSession.rememberChange(pt, history[index], editSession.rawGetBlock(pt));
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean copyToWorld(Vector pt, BaseBlock block) {
        if (block instanceof SignBlock) {
            this.setSignText(pt, ((SignBlock)block).getText());
            return true;
        }
        if (block instanceof FurnaceBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof Furnace)) {
                return false;
            }
            Furnace bukkit = (Furnace)state;
            FurnaceBlock we = (FurnaceBlock)block;
            bukkit.setBurnTime(we.getBurnTime());
            bukkit.setCookTime(we.getCookTime());
            return this.setContainerBlockContents(pt, ((ContainerBlock)block).getItems());
        }
        if (block instanceof ContainerBlock) {
            return this.setContainerBlockContents(pt, ((ContainerBlock)block).getItems());
        }
        if (block instanceof MobSpawnerBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof CreatureSpawner)) {
                return false;
            }
            CreatureSpawner bukkit = (CreatureSpawner)state;
            MobSpawnerBlock we = (MobSpawnerBlock)block;
            bukkit.setCreatureTypeByName(we.getMobType());
            bukkit.setDelay((int)we.getDelay());
            return true;
        }
        if (block instanceof com.sk89q.worldedit.blocks.NoteBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof NoteBlock)) {
                return false;
            }
            NoteBlock bukkit = (NoteBlock)state;
            com.sk89q.worldedit.blocks.NoteBlock we = (com.sk89q.worldedit.blocks.NoteBlock)block;
            bukkit.setRawNote(we.getNote());
            return true;
        }
        if (block instanceof SkullBlock) {
            BlockFace rotation;
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof Skull)) {
                return false;
            }
            Skull bukkit = (Skull)state;
            SkullBlock we = (SkullBlock)block;
            SkullType skullType = SkullType.SKELETON;
            switch (we.getSkullType()) {
                case 0: {
                    skullType = SkullType.SKELETON;
                    break;
                }
                case 1: {
                    skullType = SkullType.WITHER;
                    break;
                }
                case 2: {
                    skullType = SkullType.ZOMBIE;
                    break;
                }
                case 3: {
                    skullType = SkullType.PLAYER;
                    break;
                }
                case 4: {
                    skullType = SkullType.CREEPER;
                }
            }
            bukkit.setSkullType(skullType);
            switch (we.getRot()) {
                case 0: {
                    rotation = BlockFace.NORTH;
                    break;
                }
                case 1: {
                    rotation = BlockFace.NORTH_NORTH_EAST;
                    break;
                }
                case 2: {
                    rotation = BlockFace.NORTH_EAST;
                    break;
                }
                case 3: {
                    rotation = BlockFace.EAST_NORTH_EAST;
                    break;
                }
                case 4: {
                    rotation = BlockFace.EAST;
                    break;
                }
                case 5: {
                    rotation = BlockFace.EAST_SOUTH_EAST;
                    break;
                }
                case 6: {
                    rotation = BlockFace.SOUTH_EAST;
                    break;
                }
                case 7: {
                    rotation = BlockFace.SOUTH_SOUTH_EAST;
                    break;
                }
                case 8: {
                    rotation = BlockFace.SOUTH;
                    break;
                }
                case 9: {
                    rotation = BlockFace.SOUTH_SOUTH_WEST;
                    break;
                }
                case 10: {
                    rotation = BlockFace.SOUTH_WEST;
                    break;
                }
                case 11: {
                    rotation = BlockFace.WEST_SOUTH_WEST;
                    break;
                }
                case 12: {
                    rotation = BlockFace.WEST;
                    break;
                }
                case 13: {
                    rotation = BlockFace.WEST_NORTH_WEST;
                    break;
                }
                case 14: {
                    rotation = BlockFace.NORTH_WEST;
                    break;
                }
                case 15: {
                    rotation = BlockFace.NORTH_NORTH_WEST;
                    break;
                }
                default: {
                    rotation = BlockFace.NORTH;
                }
            }
            bukkit.setRotation(rotation);
            if (we.getOwner() != null && !we.getOwner().isEmpty()) {
                bukkit.setOwner(we.getOwner());
            }
            bukkit.update(true);
            return true;
        }
        if (!skipNmsAccess) {
            try {
                return (Boolean)nmsSetMethod.invoke(null, this.world, pt, block);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "WorldEdit: Failed to do NMS access for direct NBT data copy", t);
                skipNmsAccess = true;
            }
        }
        return false;
    }

    @Override
    public boolean copyFromWorld(Vector pt, BaseBlock block) {
        if (block instanceof SignBlock) {
            ((SignBlock)block).setText(this.getSignText(pt));
            return true;
        }
        if (block instanceof FurnaceBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof Furnace)) {
                return false;
            }
            Furnace bukkit = (Furnace)state;
            FurnaceBlock we = (FurnaceBlock)block;
            we.setBurnTime(bukkit.getBurnTime());
            we.setCookTime(bukkit.getCookTime());
            ((ContainerBlock)block).setItems(this.getContainerBlockContents(pt));
            return true;
        }
        if (block instanceof ContainerBlock) {
            ((ContainerBlock)block).setItems(this.getContainerBlockContents(pt));
            return true;
        }
        if (block instanceof MobSpawnerBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof CreatureSpawner)) {
                return false;
            }
            CreatureSpawner bukkit = (CreatureSpawner)state;
            MobSpawnerBlock we = (MobSpawnerBlock)block;
            we.setMobType(bukkit.getCreatureTypeName());
            we.setDelay((short)bukkit.getDelay());
            return true;
        }
        if (block instanceof com.sk89q.worldedit.blocks.NoteBlock) {
            Block bukkitBlock = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
            if (bukkitBlock == null) {
                return false;
            }
            BlockState state = bukkitBlock.getState();
            if (!(state instanceof NoteBlock)) {
                return false;
            }
            NoteBlock bukkit = (NoteBlock)state;
            com.sk89q.worldedit.blocks.NoteBlock we = (com.sk89q.worldedit.blocks.NoteBlock)block;
            we.setNote(bukkit.getRawNote());
            return true;
        }
        return false;
    }

    private Inventory getBlockInventory(Chest chest) {
        try {
            return chest.getBlockInventory();
        }
        catch (Throwable t) {
            if (chest.getInventory() instanceof DoubleChestInventory) {
                DoubleChestInventory inven = (DoubleChestInventory)chest.getInventory();
                if (inven.getLeftSide().getHolder().equals(chest)) {
                    return inven.getLeftSide();
                }
                if (inven.getRightSide().getHolder().equals(chest)) {
                    return inven.getRightSide();
                }
                return inven;
            }
            return chest.getInventory();
        }
    }

    @Override
    public boolean clearContainerBlockContents(Vector pt) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return false;
        }
        InventoryHolder chest = (InventoryHolder)state;
        Inventory inven = chest.getInventory();
        if (chest instanceof Chest) {
            inven = this.getBlockInventory((Chest)chest);
        }
        inven.clear();
        return true;
    }

    @Override
    @Deprecated
    public boolean generateTree(EditSession editSession, Vector pt) {
        return this.generateTree(TreeGenerator.TreeType.TREE, editSession, pt);
    }

    @Override
    @Deprecated
    public boolean generateBigTree(EditSession editSession, Vector pt) {
        return this.generateTree(TreeGenerator.TreeType.BIG_TREE, editSession, pt);
    }

    @Override
    @Deprecated
    public boolean generateBirchTree(EditSession editSession, Vector pt) {
        return this.generateTree(TreeGenerator.TreeType.BIRCH, editSession, pt);
    }

    @Override
    @Deprecated
    public boolean generateRedwoodTree(EditSession editSession, Vector pt) {
        return this.generateTree(TreeGenerator.TreeType.REDWOOD, editSession, pt);
    }

    @Override
    @Deprecated
    public boolean generateTallRedwoodTree(EditSession editSession, Vector pt) {
        return this.generateTree(TreeGenerator.TreeType.TALL_REDWOOD, editSession, pt);
    }

    public static TreeType toBukkitTreeType(TreeGenerator.TreeType type) {
        return treeTypeMapping.get((Object)type);
    }

    @Override
    public boolean generateTree(TreeGenerator.TreeType type, EditSession editSession, Vector pt) {
        TreeType bukkitType = BukkitWorld.toBukkitTreeType(type);
        return type != null && this.world.generateTree(BukkitUtil.toLocation(this.world, pt), bukkitType, (BlockChangeDelegate)new EditSessionBlockChangeDelegate(editSession));
    }

    @Override
    public void dropItem(Vector pt, BaseItemStack item) {
        ItemStack bukkitItem = new ItemStack(item.getType(), item.getAmount(), item.getData());
        this.world.dropItemNaturally(BukkitUtil.toLocation(this.world, pt), bukkitItem);
    }

    @Override
    public int killMobs(Vector origin, double radius, int flags) {
        boolean killPets = (flags & 1) != 0;
        boolean killNPCs = (flags & 2) != 0;
        boolean killAnimals = (flags & 4) != 0;
        boolean withLightning = (flags & 0x100000) != 0;
        boolean killGolems = (flags & 8) != 0;
        boolean killAmbient = (flags & 0x10) != 0;
        int num = 0;
        double radiusSq = radius * radius;
        Location bukkitOrigin = BukkitUtil.toLocation(this.world, origin);
        for (LivingEntity ent : this.world.getLivingEntities()) {
            if (ent instanceof HumanEntity || !killAnimals && ent instanceof Animals || !killPets && ent instanceof Tameable && ((Tameable)ent).isTamed() || !killGolems && ent instanceof Golem || !killNPCs && ent instanceof Villager || !killAmbient && ent instanceof Ambient || !(radius < 0.0) && !(bukkitOrigin.distanceSquared(ent.getLocation()) <= radiusSq)) continue;
            if (withLightning) {
                this.world.strikeLightningEffect(ent.getLocation());
            }
            ent.remove();
            ++num;
        }
        return num;
    }

    @Override
    public int removeEntities(EntityType type, Vector origin, int radius) {
        int num = 0;
        double radiusSq = Math.pow(radius, 2.0);
        for (Entity ent : this.world.getEntities()) {
            if (radius != -1 && origin.distanceSq(BukkitUtil.toVector(ent.getLocation())) > radiusSq) continue;
            switch (type) {
                case ALL: {
                    if (!(ent instanceof Projectile) && !(ent instanceof Boat) && !(ent instanceof Item) && !(ent instanceof FallingBlock) && !(ent instanceof Minecart) && !(ent instanceof Hanging) && !(ent instanceof TNTPrimed) && !(ent instanceof ExperienceOrb)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case PROJECTILES: 
                case ARROWS: {
                    if (!(ent instanceof Projectile)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case BOATS: {
                    if (!(ent instanceof Boat)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case ITEMS: {
                    if (!(ent instanceof Item)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case FALLING_BLOCKS: {
                    if (!(ent instanceof FallingBlock)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case MINECARTS: {
                    if (!(ent instanceof Minecart)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case PAINTINGS: {
                    if (!(ent instanceof Painting)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case ITEM_FRAMES: {
                    if (!(ent instanceof ItemFrame)) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case TNT: {
                    if (!(ent instanceof TNTPrimed) && ent.getType() != tntMinecartType) break;
                    ent.remove();
                    ++num;
                    break;
                }
                case XP_ORBS: {
                    if (!(ent instanceof ExperienceOrb)) break;
                    ent.remove();
                    ++num;
                }
            }
        }
        return num;
    }

    private boolean setSignText(Vector pt, String[] text) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (state == null || !(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        sign.setLine(0, text[0]);
        sign.setLine(1, text[1]);
        sign.setLine(2, text[2]);
        sign.setLine(3, text[3]);
        sign.update();
        return true;
    }

    private String[] getSignText(Vector pt) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return new String[]{"", "", "", ""};
        }
        BlockState state = block.getState();
        if (state == null || !(state instanceof Sign)) {
            return new String[]{"", "", "", ""};
        }
        Sign sign = (Sign)state;
        String line0 = sign.getLine(0);
        String line1 = sign.getLine(1);
        String line2 = sign.getLine(2);
        String line3 = sign.getLine(3);
        return new String[]{line0 != null ? line0 : "", line1 != null ? line1 : "", line2 != null ? line2 : "", line3 != null ? line3 : ""};
    }

    private BaseItemStack[] getContainerBlockContents(Vector pt) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return new BaseItemStack[0];
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return new BaseItemStack[0];
        }
        InventoryHolder container = (InventoryHolder)state;
        Inventory inven = container.getInventory();
        if (container instanceof Chest) {
            inven = this.getBlockInventory((Chest)container);
        }
        int size = inven.getSize();
        BaseItemStack[] contents = new BaseItemStack[size];
        for (int i = 0; i < size; ++i) {
            ItemStack bukkitStack = inven.getItem(i);
            if (bukkitStack == null || bukkitStack.getTypeId() <= 0) continue;
            contents[i] = new BaseItemStack(bukkitStack.getTypeId(), bukkitStack.getAmount(), bukkitStack.getDurability());
            try {
                for (Map.Entry entry : bukkitStack.getEnchantments().entrySet()) {
                    contents[i].getEnchantments().put(((Enchantment)entry.getKey()).getId(), (Integer)entry.getValue());
                }
                continue;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return contents;
    }

    private boolean setContainerBlockContents(Vector pt, BaseItemStack[] contents) {
        Block block = this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ());
        if (block == null) {
            return false;
        }
        BlockState state = block.getState();
        if (!(state instanceof InventoryHolder)) {
            return false;
        }
        InventoryHolder chest = (InventoryHolder)state;
        Inventory inven = chest.getInventory();
        if (chest instanceof Chest) {
            inven = this.getBlockInventory((Chest)chest);
        }
        int size = inven.getSize();
        for (int i = 0; i < size && i < contents.length; ++i) {
            if (contents[i] != null) {
                ItemStack toAdd = new ItemStack(contents[i].getType(), contents[i].getAmount(), contents[i].getData());
                try {
                    for (Map.Entry<Integer, Integer> entry : contents[i].getEnchantments().entrySet()) {
                        toAdd.addEnchantment(Enchantment.getById((int)entry.getKey()), entry.getValue().intValue());
                    }
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
                inven.setItem(i, toAdd);
                continue;
            }
            inven.setItem(i, null);
        }
        return true;
    }

    @Override
    public boolean isValidBlockType(int type) {
        if (!skipNmsValidBlockCheck) {
            try {
                return (Boolean)nmsValidBlockMethod.invoke(null, type);
            }
            catch (Throwable e) {
                skipNmsValidBlockCheck = true;
            }
        }
        return Material.getMaterial((int)type) != null && Material.getMaterial((int)type).isBlock();
    }

    @Override
    public void checkLoadedChunk(Vector pt) {
        if (!this.world.isChunkLoaded(pt.getBlockX() >> 4, pt.getBlockZ() >> 4)) {
            this.world.loadChunk(pt.getBlockX() >> 4, pt.getBlockZ() >> 4);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof BukkitWorld)) {
            return false;
        }
        return ((BukkitWorld)other).world.equals(this.world);
    }

    @Override
    public int hashCode() {
        return this.world.hashCode();
    }

    @Override
    public int getMaxY() {
        return this.world.getMaxHeight() - 1;
    }

    @Override
    public void fixAfterFastMode(Iterable<BlockVector2D> chunks) {
        for (BlockVector2D chunkPos : chunks) {
            this.world.refreshChunk(chunkPos.getBlockX(), chunkPos.getBlockZ());
        }
    }

    @Override
    public boolean playEffect(Vector position, int type, int data) {
        Effect effect = effects.get(type);
        if (effect == null) {
            return false;
        }
        this.world.playEffect(BukkitUtil.toLocation(this.world, position), effect, data);
        return true;
    }

    @Override
    public void simulateBlockMine(Vector pt) {
        this.world.getBlockAt(pt.getBlockX(), pt.getBlockY(), pt.getBlockZ()).breakNaturally();
    }

    @Override
    public LocalEntity[] getEntities(Region region) {
        ArrayList<BukkitEntity> entities = new ArrayList<BukkitEntity>();
        for (Vector2D pt : region.getChunks()) {
            Entity[] ents;
            if (!this.world.isChunkLoaded(pt.getBlockX(), pt.getBlockZ())) continue;
            for (Entity ent : ents = this.world.getChunkAt(pt.getBlockX(), pt.getBlockZ()).getEntities()) {
                if (!region.contains(BukkitUtil.toVector(ent.getLocation()))) continue;
                entities.add(BukkitUtil.toLocalEntity(ent));
            }
        }
        return entities.toArray(new BukkitEntity[entities.size()]);
    }

    @Override
    public int killEntities(LocalEntity ... entities) {
        int amount = 0;
        HashSet<UUID> toKill = new HashSet<UUID>();
        for (LocalEntity entity : entities) {
            toKill.add(((BukkitEntity)entity).getEntityId());
        }
        for (Entity entity : this.world.getEntities()) {
            if (!toKill.contains(entity.getUniqueId())) continue;
            entity.remove();
            ++amount;
        }
        return amount;
    }

    @Override
    public BaseBlock getBlock(Vector pt) {
        int type = this.getBlockType(pt);
        int data = this.getBlockData(pt);
        switch (type) {
            case 25: 
            case 63: 
            case 68: 
            case 144: {
                return super.getBlock(pt);
            }
        }
        if (!skipNmsAccess) {
            try {
                NmsBlock block = null;
                block = (NmsBlock)nmsGetMethod.invoke(null, this.getWorld(), pt, type, data);
                if (block != null) {
                    return block;
                }
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "WorldEdit: Failed to do NMS access for direct NBT data copy", t);
                skipNmsAccess = true;
            }
        }
        return super.getBlock(pt);
    }

    @Override
    public boolean setBlock(Vector pt, com.sk89q.worldedit.foundation.Block block, boolean notifyAdjacent) {
        if (!skipNmsSafeSet) {
            try {
                return (Boolean)nmsSetSafeMethod.invoke(null, this, pt, block, notifyAdjacent);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "WorldEdit: Failed to do NMS safe block set", t);
                skipNmsSafeSet = true;
            }
        }
        return super.setBlock(pt, block, notifyAdjacent);
    }

    static {
        checkMinecartType = true;
        treeTypeMapping = new EnumMap(TreeGenerator.TreeType.class);
        treeTypeMapping.put(TreeGenerator.TreeType.SWAMP, TreeType.TREE);
        treeTypeMapping.put(TreeGenerator.TreeType.JUNGLE_BUSH, TreeType.TREE);
        try {
            treeTypeMapping.put(TreeGenerator.TreeType.SHORT_JUNGLE, TreeType.valueOf((String)"SMALL_JUNGLE"));
        }
        catch (IllegalArgumentException e) {
            treeTypeMapping.put(TreeGenerator.TreeType.SHORT_JUNGLE, TreeType.TREE);
        }
        for (TreeGenerator.TreeType treeType : TreeGenerator.TreeType.values()) {
            try {
                TreeType bukkitType = TreeType.valueOf((String)treeType.name());
                treeTypeMapping.put(treeType, bukkitType);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM, TreeType.BROWN_MUSHROOM);
        treeTypeMapping.put(TreeGenerator.TreeType.RANDOM_REDWOOD, TreeType.REDWOOD);
        treeTypeMapping.put(TreeGenerator.TreeType.PINE, TreeType.REDWOOD);
        for (TreeGenerator.TreeType treeType : TreeGenerator.TreeType.values()) {
            if (treeTypeMapping.get((Object)treeType) != null) continue;
            WorldEdit.logger.severe("No TreeType mapping for TreeGenerator.TreeType." + (Object)((Object)treeType));
        }
        effects = new HashMap<Integer, Effect>();
        for (TreeGenerator.TreeType treeType : Effect.values()) {
            effects.put(treeType.getId(), (Effect)treeType);
        }
    }

    private class NmsBlockClassLoader
    extends ClassLoader {
        public File searchDir;

        public NmsBlockClassLoader(ClassLoader parent, File searchDir) {
            super(parent);
            this.searchDir = searchDir;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (!name.startsWith("CL-NMS")) {
                return super.loadClass(name);
            }
            name = name.replace("CL-NMS", "");
            try {
                URL url = new File(this.searchDir, name).toURI().toURL();
                InputStream input = url.openConnection().getInputStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                int data = input.read();
                while (data != -1) {
                    buffer.write(data);
                    data = input.read();
                }
                input.close();
                byte[] classData = buffer.toByteArray();
                return this.defineClass(name.replaceFirst(".class$", ""), classData, 0, classData.length);
            }
            catch (Throwable e) {
                throw new ClassNotFoundException();
            }
        }
    }
}

