/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.masks.BiomeTypeMask;
import com.sk89q.worldedit.masks.InvertedMask;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.StringUtil;
import java.util.HashSet;
import java.util.List;

public class BiomeCommands {
    private WorldEdit we;

    public BiomeCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"biomelist", "biomels"}, usage="[page]", desc="\u041f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u0431\u0438\u043e\u043c\u043e\u0432.", max=1)
    @CommandPermissions(value={"worldedit.biome.list"})
    public void biomeList(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int offset;
        int page;
        int count = 0;
        if (args.argsLength() == 0 || (page = args.getInteger(0)) < 2) {
            page = 1;
            offset = 0;
        } else {
            offset = (page - 1) * 19;
        }
        List<BiomeType> biomes = this.we.getServer().getBiomes().all();
        int totalPages = biomes.size() / 19 + 1;
        player.print("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0431\u0438\u043e\u043c\u044b (\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 " + page + "/" + totalPages + ") :");
        for (BiomeType biome : biomes) {
            if (offset > 0) {
                --offset;
                continue;
            }
            player.print(" " + biome.getName());
            if (++count != 19) continue;
            break;
        }
    }

    @Command(aliases={"biomeinfo"}, flags="pt", desc="\u041f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0431\u0438\u043e\u043c \u0431\u043b\u043e\u043a\u0430 \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0412\u044b \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435.", help="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0431\u0438\u043e\u043c\u0430 \u0431\u043b\u043e\u043a\u0430.\n\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0432\u0441\u0435 \u0431\u043b\u043e\u043a\u0438, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0412\u044b \u0432\u044b\u0434\u0435\u043b\u0438\u043b\u0438.\n-t \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0431\u043b\u043e\u043a,\u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0412\u044b \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435.\n-p \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u0431\u043b\u043e\u043a,\u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0412\u044b \u0441\u0442\u043e\u0438\u0442\u0435", max=0)
    @CommandPermissions(value={"worldedit.biome.info"})
    public void biomeInfo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (args.hasFlag('t')) {
            WorldVector blockPosition = player.getBlockTrace(300);
            if (blockPosition == null) {
                player.printError("\u041d\u0435\u0442 \u0431\u043b\u043e\u043a\u043e\u0432 \u0432 \u043f\u043e\u043b\u0435 \u0437\u0440\u0435\u043d\u0438\u044f!");
                return;
            }
            BiomeType biome = player.getWorld().getBiome(blockPosition.toVector2D());
            player.print("\u0411\u0438\u043e\u043c: " + biome.getName());
        } else if (args.hasFlag('p')) {
            BiomeType biome = player.getWorld().getBiome(player.getPosition().toVector2D());
            player.print("\u0411\u0438\u043e\u043c: " + biome.getName());
        } else {
            LocalWorld world = player.getWorld();
            Region region = session.getSelection(world);
            HashSet<BiomeType> biomes = new HashSet<BiomeType>();
            if (region instanceof FlatRegion) {
                for (Vector2D vector2D : ((FlatRegion)region).asFlatRegion()) {
                    biomes.add(world.getBiome(vector2D));
                }
            } else {
                for (Vector vector : region) {
                    biomes.add(world.getBiome(vector.toVector2D()));
                }
            }
            player.print("\u0411\u0438\u043e\u043c\u044b:");
            for (BiomeType biomeType : biomes) {
                player.print(" " + biomeType.getName());
            }
        }
    }

    @Command(aliases={"/setbiome"}, usage="<biome>", flags="p", desc="\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0431\u0438\u043e\u043c \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0431\u043b\u043e\u043a\u0430,\u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0412\u044b \u0441\u0442\u043e\u0438\u0442\u0435 \u0438\u043b\u0438 \u0440\u0435\u0433\u0438\u043e\u043d\u0430.", help="\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0431\u0438\u043e\u043c \u0440\u0435\u0433\u0438\u043e\u043d\u0430.\n\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u0432\u0441\u0435 \u0431\u043b\u043e\u043a\u0438 \u0432 \u0440\u0435\u0433\u0438\u043e\u043d\u0435.\n-p \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0431\u043b\u043e\u043a, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u043c \u0412\u044b \u0441\u0435\u0439\u0447\u0430\u0441 \u0441\u0442\u043e\u0438\u0442\u0435.", min=1, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.biome.set"})
    public void setBiome(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        BiomeType target = this.we.getServer().getBiomes().get(args.getString(0));
        if (target == null) {
            player.printError("\u0411\u0438\u043e\u043c\u0430 '" + args.getString(0) + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
            return;
        }
        Mask mask = editSession.getMask();
        BiomeTypeMask biomeMask = null;
        boolean inverted = false;
        if (mask instanceof BiomeTypeMask) {
            biomeMask = (BiomeTypeMask)mask;
        } else if (mask instanceof InvertedMask && ((InvertedMask)mask).getInvertedMask() instanceof BiomeTypeMask) {
            inverted = true;
            biomeMask = (BiomeTypeMask)((InvertedMask)mask).getInvertedMask();
        }
        if (args.hasFlag('p')) {
            Vector2D pos = player.getPosition().toVector2D();
            if (biomeMask == null || biomeMask.matches2D(editSession, pos) ^ inverted) {
                player.getWorld().setBiome(pos, target);
                player.print("\u0411\u0438\u043e\u043c \u0432 \u0442\u0432\u043e\u0435\u043c \u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043d\u0430 " + target.getName() + ".");
            } else {
                player.print("\u0412\u0430\u0448\u0430 \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u0430\u043a\u0441\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0431\u0438\u043e\u043c\u0443. \u0414\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043c\u0430\u0441\u043a\u0438 \u0432\u0432\u0435\u0434\u0438\u0442\u0435 //gmask.");
            }
        } else {
            int affected = 0;
            LocalWorld world = player.getWorld();
            Region region = session.getSelection(world);
            if (region instanceof FlatRegion) {
                for (Vector2D pt : ((FlatRegion)region).asFlatRegion()) {
                    if (biomeMask != null && !(biomeMask.matches2D(editSession, pt) ^ inverted)) continue;
                    world.setBiome(pt, target);
                    ++affected;
                }
            } else {
                HashSet<Long> alreadyVisited = new HashSet<Long>();
                for (Vector pt : region) {
                    if (alreadyVisited.contains((long)pt.getBlockX() << 32 | (long)pt.getBlockZ())) continue;
                    alreadyVisited.add((long)pt.getBlockX() << 32 | (long)pt.getBlockZ());
                    if (biomeMask != null && !(biomeMask.matches(editSession, pt) ^ inverted)) continue;
                    world.setBiome(pt.toVector2D(), target);
                    ++affected;
                }
            }
            player.print("\u0411\u0438\u043e\u043c \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043d\u0430 " + target.getName() + ". " + affected + " " + StringUtil.plural(affected, "\u0447\u0430\u043d\u043a \u0437\u0430\u043c\u0435\u043d\u0435\u043d", "\u0447\u0430\u043d\u043a\u0430 \u0437\u0430\u043c\u0435\u043d\u0435\u043d\u043e", "\u0447\u0430\u043d\u043a\u043e\u0432 \u0437\u0430\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
        }
    }
}

