/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.data.LegacyChunkStore;
import com.sk89q.worldedit.data.McRegionChunkStore;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Set;

public class ChunkCommands {
    private final WorldEdit we;

    public ChunkCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"chunkinfo"}, usage="", desc="\u041f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0447\u0430\u043d\u043a\u0435 \u0433\u0434\u0435 \u0412\u044b \u0441\u0435\u0439\u0447\u0430\u0441 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0435\u0441\u044c", min=0, max=0)
    @CommandPermissions(value={"worldedit.chunkinfo"})
    public void chunkInfo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockIn();
        int chunkX = (int)Math.floor((double)pos.getBlockX() / 16.0);
        int chunkZ = (int)Math.floor((double)pos.getBlockZ() / 16.0);
        String folder1 = Integer.toString(WorldEdit.divisorMod(chunkX, 64), 36);
        String folder2 = Integer.toString(WorldEdit.divisorMod(chunkZ, 64), 36);
        String filename = "c." + Integer.toString(chunkX, 36) + "." + Integer.toString(chunkZ, 36) + ".dat";
        player.print("\u0427\u0430\u043d\u043a: " + chunkX + ", " + chunkZ);
        player.print("\u0421\u0442\u0430\u0440\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442: " + folder1 + "/" + folder2 + "/" + filename);
        player.print("McRegion: region/" + McRegionChunkStore.getFilename(new Vector2D(chunkX, chunkZ)));
    }

    @Command(aliases={"listchunks"}, usage="", desc="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0447\u0430\u043d\u043a\u0438 \u0443 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", min=0, max=0)
    @CommandPermissions(value={"worldedit.listchunks"})
    public void listChunks(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Set<Vector2D> chunks = session.getSelection(player.getWorld()).getChunks();
        for (Vector2D chunk : chunks) {
            player.print(LegacyChunkStore.getFilename(chunk));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"delchunks"}, usage="", desc="\u0423\u0434\u0430\u043b\u044f\u0435\u0442 \u0447\u0430\u043d\u043a\u0438 \u0443 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", min=0, max=0)
    @CommandPermissions(value={"worldedit.delchunks"})
    @Logging(value=Logging.LogMode.REGION)
    public void deleteChunks(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("\u041d\u0430\u043f\u043e\u043c\u0438\u043d\u0430\u043d\u0438\u0435: \u0414\u0430\u043d\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442 \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u0432 mcregion.");
        LocalConfiguration config = this.we.getConfiguration();
        Set<Vector2D> chunks = session.getSelection(player.getWorld()).getChunks();
        FileOutputStream out = null;
        if (config.shellSaveType == null) {
            player.printError("\u0421\u043a\u0440\u0438\u043f\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d: \u0444\u043e\u0440\u043c\u0430\u0442 'bat' \u0438\u043b\u0438 'bash'.");
        } else if (config.shellSaveType.equalsIgnoreCase("bat")) {
            try {
                out = new FileOutputStream("worldedit-delchunks.bat");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write("@ECHO off\r\n");
                writer.write("ECHO This batch file was generated by WorldEdit.\r\n");
                writer.write("ECHO It contains a list of chunks that were in the selected region\r\n");
                writer.write("ECHO at the time that the /delchunks command was used. Run this file\r\n");
                writer.write("ECHO in order to delete the chunk files listed in this file.\r\n");
                writer.write("ECHO.\r\n");
                writer.write("PAUSE\r\n");
                for (Vector2D chunk : chunks) {
                    String filename = LegacyChunkStore.getFilename(chunk);
                    writer.write("ECHO " + filename + "\r\n");
                    writer.write("DEL \"world/" + filename + "\"\r\n");
                }
                writer.write("ECHO Complete.\r\n");
                writer.write("PAUSE\r\n");
                writer.close();
                player.print("worldedit-delchunks.bat written. Run it when no one is near the region.");
            }
            catch (IOException e) {
                player.printError("Error occurred: " + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ie) {}
                }
            }
        } else if (config.shellSaveType.equalsIgnoreCase("bash")) {
            try {
                out = new FileOutputStream("worldedit-delchunks.sh");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
                writer.write("#!/bin/bash\n");
                writer.write("echo This shell file was generated by WorldEdit.\n");
                writer.write("echo It contains a list of chunks that were in the selected region\n");
                writer.write("echo at the time that the /delchunks command was used. Run this file\n");
                writer.write("echo in order to delete the chunk files listed in this file.\n");
                writer.write("echo\n");
                writer.write("read -p \"Press any key to continue...\"\n");
                for (Vector2D chunk : chunks) {
                    String filename = LegacyChunkStore.getFilename(chunk);
                    writer.write("echo " + filename + "\n");
                    writer.write("rm \"world/" + filename + "\"\n");
                }
                writer.write("echo Complete.\n");
                writer.write("read -p \"Press any key to continue...\"\n");
                writer.close();
                player.print("worldedit-delchunks.sh \u0441\u043e\u0437\u0434\u0430\u043d. \u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u0435 \u0435\u0433\u043e, \u043a\u043e\u0433\u0434\u0430 \u043d\u0438\u043a\u0442\u043e \u043d\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0434\u0430\u043d\u043d\u044b\u0445 \u0440\u0435\u0433\u0438\u043e\u043d\u0430\u0445.");
                player.print("\u0422\u0430\u043a \u0436\u0435 \u0444\u0430\u0439\u043b \u0434\u043e\u043b\u0436\u0435\u043d \u0438\u043c\u0435\u0442\u044c \u043f\u0440\u0430\u0432\u0430 \u043d\u0430 \u0437\u0430\u043f\u0443\u0441\u043a.");
            }
            catch (IOException e) {
                player.printError("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ie) {}
                }
            }
        } else {
            player.printError("\u0421\u043a\u0440\u0438\u043f\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d: \u0444\u043e\u0440\u043c\u0430\u0442 'bat' \u0438\u043b\u0438 'bash'.");
        }
    }
}

