/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalEntity;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.commands.SchematicCommands;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.StringUtil;

public class ClipboardCommands {
    private final WorldEdit we;

    public ClipboardCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/copy"}, flags="e", desc="\u041a\u043e\u043f\u0438\u0440\u0443\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", help="\u041a\u043e\u043f\u0438\u0440\u0443\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\n\u0424\u043b\u0430\u0433\u0438:\n  -e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442, \u0431\u0443\u0434\u0443\u0442 \u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430\n\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415: \u0412\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u044b!", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.copy"})
    public void copy(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        Vector pos = session.getPlacementPosition(player);
        CuboidClipboard clipboard = new CuboidClipboard(max.subtract(min).add(Vector.ONE), min, min.subtract(pos));
        if (region instanceof CuboidRegion) {
            clipboard.copy(editSession);
        } else {
            clipboard.copy(editSession, region);
        }
        if (args.hasFlag('e')) {
            for (LocalEntity entity : player.getWorld().getEntities(region)) {
                clipboard.storeEntity(entity);
            }
        }
        session.setClipboard(clipboard);
        player.print("\u0411\u043b\u043e\u043a(\u0438) \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d(\u044b).");
    }

    @Command(aliases={"/cut"}, usage="[leave-id]", desc="\u0412\u044b\u0440\u0435\u0437\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", help="\u0412\u044b\u0440\u0435\u0437\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430\n\u0424\u043b\u0430\u0433\u0438:\n  -e controls \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442, \u0431\u0443\u0434\u0443\u0442 \u043b\u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430\n\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415: \u0412\u044b\u0440\u0435\u0437\u0430\u043d\u043d\u044b\u0435 \u0438 \u0432\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u043d\u0435 \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u044b!", flags="e", min=0, max=1)
    @CommandPermissions(value={"worldedit.clipboard.cut"})
    @Logging(value=Logging.LogMode.REGION)
    public void cut(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        BaseBlock block = new BaseBlock(0);
        LocalWorld world = player.getWorld();
        if (args.argsLength() > 0) {
            block = this.we.getBlock(player, args.getString(0));
        }
        Region region = session.getSelection(world);
        Vector min = region.getMinimumPoint();
        Vector max = region.getMaximumPoint();
        Vector pos = session.getPlacementPosition(player);
        CuboidClipboard clipboard = new CuboidClipboard(max.subtract(min).add(Vector.ONE), min, min.subtract(pos));
        if (region instanceof CuboidRegion) {
            clipboard.copy(editSession);
        } else {
            clipboard.copy(editSession, region);
        }
        if (args.hasFlag('e')) {
            LocalEntity[] entities;
            for (LocalEntity entity : entities = world.getEntities(region)) {
                clipboard.storeEntity(entity);
            }
            world.killEntities(entities);
        }
        session.setClipboard(clipboard);
        int affected = editSession.setBlocks(region, block);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0432\u044b\u0440\u0435\u0437\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0432\u044b\u0440\u0435\u0437\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0432\u044b\u0440\u0435\u0437\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"/paste"}, usage="", flags="ao", desc="\u0412\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", help="\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430.\n\u0424\u043b\u0430\u0433\u0438:\n  -a \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442 \u0431\u043b\u043e\u043a\u0438 \u0432\u043e\u0437\u0434\u0443\u0445\u0430\n  -o \u0432\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u044f\u0445, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0431\u044b\u043b\u0438 \u0441\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u044b/\u0432\u044b\u0440\u0435\u0437\u0430\u043d\u044b", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.paste"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void paste(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        boolean atOrigin = args.hasFlag('o');
        boolean pasteNoAir = args.hasFlag('a');
        if (atOrigin) {
            Vector pos = session.getClipboard().getOrigin();
            session.getClipboard().place(editSession, pos, pasteNoAir);
            session.getClipboard().pasteEntities(pos);
            player.findFreePosition();
            player.print("\u0412\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e. \u0414\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 //undo");
        } else {
            Vector pos = session.getPlacementPosition(player);
            session.getClipboard().paste(editSession, pos, pasteNoAir, true);
            player.findFreePosition();
            player.print("\u0412\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e. \u0414\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043d\u0430\u043f\u0438\u0448\u0438\u0442\u0435 //undo");
        }
    }

    @Command(aliases={"/rotate"}, usage="<angle-in-degrees>", desc="\u041f\u043e\u0432\u043e\u0440\u043e\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", min=1, max=1)
    @CommandPermissions(value={"worldedit.clipboard.rotate"})
    public void rotate(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int angle = args.getInteger(0);
        if (angle % 90 == 0) {
            CuboidClipboard clipboard = session.getClipboard();
            clipboard.rotate2D(angle);
            player.print("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 \u043f\u043e\u0432\u0435\u0440\u043d\u0443\u0442\u043e \u043d\u0430 " + angle + " \u0433\u0440\u0430\u0434\u0443\u0441\u043e\u0432.");
        } else {
            player.printError("\u0423\u0433\u043b\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0434\u0435\u043b\u0438\u0442\u044c\u0441\u044f \u043d\u0430 90 \u0433\u0440\u0430\u0434\u0443\u0441\u043e\u0432.");
        }
    }

    @Command(aliases={"/flip"}, usage="[dir]", flags="p", desc="\u041f\u0435\u0440\u0435\u0432\u043e\u0440\u0430\u0447\u0438\u0432\u0430\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430.", help="\u041f\u0435\u0440\u0435\u0432\u043e\u0440\u0430\u0447\u0438\u0432\u0430\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430.\n\u0424\u043b\u0430\u0433 -p \u043f\u0435\u0440\u0435\u0432\u043e\u0440\u0430\u0447\u0438\u0432\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0432\u043e\u043a\u0440\u0443\u0433 \u0438\u0433\u0440\u043e\u043a\u0430,\n\u0430 \u043d\u0435 \u0446\u0435\u043d\u0442\u0440\u0430 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f.", min=0, max=1)
    @CommandPermissions(value={"worldedit.clipboard.flip"})
    public void flip(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        CuboidClipboard.FlipDirection dir = this.we.getFlipDirection(player, args.argsLength() > 0 ? args.getString(0).toLowerCase() : "me");
        CuboidClipboard clipboard = session.getClipboard();
        clipboard.flip(dir, args.hasFlag('p'));
        player.print("\u0421\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 \u043f\u0435\u0440\u0435\u0432\u0435\u0440\u043d\u0443\u0442\u043e.");
    }

    @Command(aliases={"/load"}, usage="<filename>", desc="\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442 \u0441\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0444\u0430\u0439\u043b \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430.", min=0, max=1)
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.load"})
    public void load(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.printError("\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f. \u041f\u0438\u0448\u0438\u0442\u0435 //schematic load.");
    }

    @Command(aliases={"/save"}, usage="<filename>", desc="\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u0442 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430 \u0432 \u0441\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0444\u0430\u0439\u043b.", min=0, max=1)
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.save"})
    public void save(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.printError("\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f. \u041f\u0438\u0448\u0438\u0442\u0435 //schematic save.");
    }

    @Command(aliases={"/schematic", "/schem"}, desc="\u041a\u043e\u043c\u0430\u043d\u0434\u044b, \u0441\u0432\u044f\u0437\u0430\u043d\u043d\u044b\u0435 \u0441 \u0431\u0443\u0444\u0435\u0440\u043e\u043c \u043e\u0431\u043c\u0435\u043d\u0430 \u0438 \u0441\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u043c\u0438 \u0444\u0430\u0439\u043b\u0430\u043c\u0438.")
    @NestedCommand(value={SchematicCommands.class})
    public void schematic() {
    }

    @Command(aliases={"clearclipboard"}, usage="", desc="\u041e\u0447\u0438\u0449\u0430\u0435\u0442 \u0412\u0430\u0448 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.clear"})
    public void clearClipboard(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setClipboard(null);
        player.print("\u0411\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430 \u043e\u0447\u0438\u0449\u0435\u043d.");
    }
}

