/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Console;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldedit.commands.WorldEditCommands;
import com.sk89q.worldedit.masks.Mask;

public class GeneralCommands {
    private final WorldEdit we;

    public GeneralCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/limit"}, usage="<limit>", desc="\u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442 \u043b\u0438\u043c\u0438\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u043a\u043e\u0432", min=1, max=1)
    @CommandPermissions(value={"worldedit.limit"})
    public void limit(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int limit = Math.max(-1, args.getInteger(0));
        if (!player.hasPermission("worldedit.limit.unrestricted") && config.maxChangeLimit > -1 && limit > config.maxChangeLimit) {
            player.printError("\u0412\u0430\u0448 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0439 \u043b\u0438\u043c\u0438\u0442 " + config.maxChangeLimit + ".");
            return;
        }
        session.setBlockChangeLimit(limit);
        player.print("\u041b\u0438\u043c\u0438\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0431\u043b\u043e\u043a\u043e\u0432 \u0441\u043c\u0435\u043d\u0435\u043d \u043d\u0430 " + limit + ".");
    }

    @Command(aliases={"/fast"}, usage="[on|off]", desc="\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0439 \u0440\u0435\u0436\u0438\u043c.", min=0, max=1)
    @CommandPermissions(value={"worldedit.fast"})
    public void fast(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String newState = args.getString(0, null);
        if (session.hasFastMode()) {
            if ("on".equals(newState)) {
                player.printError("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0439 \u0440\u0435\u0436\u0438\u043c \u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d.");
                return;
            }
            session.setFastMode(false);
            player.print("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0439 \u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d.");
        } else {
            if ("off".equals(newState)) {
                player.printError("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0439 \u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d.");
                return;
            }
            session.setFastMode(true);
            player.print("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0439 \u0440\u0435\u0436\u0438\u043c \u0432\u043a\u043b\u044e\u0447\u0435\u043d. \u041e\u0441\u0432\u0435\u0449\u0435\u043d\u0438\u0435 \u0432 \u0447\u0430\u043d\u043a\u0430\u0445 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u043c \u0438 \u0412\u0430\u043c \u043f\u0440\u0438\u0439\u0434\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0439\u0442\u0438 \u043d\u0430 \u0441\u0435\u0440\u0432\u0435\u0440, \u0447\u0442\u043e\u0431\u044b \u0443\u0432\u0438\u0434\u0435\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f.");
        }
    }

    @Command(aliases={"/gmask", "gmask"}, usage="[mask]", desc="\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0433\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0443\u044e \u043c\u0430\u0441\u043a\u0443.", min=0, max=-1)
    @CommandPermissions(value={"worldedit.global-mask"})
    public void gmask(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (args.argsLength() == 0) {
            session.setMask(null);
            player.print("\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u0430\u0441\u043a\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        } else {
            Mask mask = this.we.getBlockMask(player, session, args.getJoinedStrings(0));
            session.setMask(mask);
            player.print("\u0413\u043b\u043e\u0431\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u0430\u0441\u043a\u0430 \u0437\u0430\u0434\u0430\u043d\u0430.");
        }
    }

    @Command(aliases={"/toggleplace", "toggleplace"}, usage="", desc="\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u0432\u0430\u0448\u0438\u043c \u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0435\u043c \u0438 pos1 \u0434\u043b\u044f \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u044f", min=0, max=0)
    public void togglePlace(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (session.togglePlacementPosition()) {
            player.print("\u0420\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043d\u0430 \u0442\u043e\u0447\u043a\u0435 #1.");
        } else {
            player.print("\u0411\u043b\u043e\u043a \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d \u043d\u0430 \u0412\u0430\u0448\u0435\u043c \u043c\u0435\u0441\u0442\u043e\u0440\u0430\u0441\u043f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u0438.");
        }
    }

    @Command(aliases={"/searchitem", "/l", "/search", "searchitem"}, usage="<query>", flags="bi", desc="\u041f\u043e\u0438\u0441\u043a \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432", help="\u0418\u0449\u0435\u0442 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u044b.\n\u0424\u043b\u0430\u0433\u0438:\n  -b \u043f\u043e\u0438\u0441\u043a \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043b\u043e\u043a\u043e\u0432\n  -i \u043f\u043e\u0438\u0441\u043a \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432", min=1, max=1)
    @Console
    public void searchItem(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String query = args.getString(0).trim().toLowerCase();
        boolean blocksOnly = args.hasFlag('b');
        boolean itemsOnly = args.hasFlag('i');
        try {
            int id = Integer.parseInt(query);
            ItemType type = ItemType.fromID(id);
            if (type != null) {
                player.print("#" + type.getID() + " (" + type.getName() + ")");
            } else {
                player.printError("\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u043f\u043e\u0434 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c " + id + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
            }
            return;
        }
        catch (NumberFormatException e) {
            if (query.length() <= 2) {
                player.printError("\u0412 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u043e \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 (\u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0434\u0432\u0443\u0445).");
                return;
            }
            if (!blocksOnly && !itemsOnly) {
                player.print("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0434\u043b\u044f: " + query);
            } else {
                if (blocksOnly && itemsOnly) {
                    player.printError("\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0444\u043b\u0430\u0433\u0438 -b \u0438 -i.");
                    return;
                }
                if (blocksOnly) {
                    player.print("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0434\u043b\u044f \u0431\u043b\u043e\u043a\u043e\u0432: " + query);
                } else {
                    player.print("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0434\u043b\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432: " + query);
                }
            }
            int found = 0;
            block2: for (ItemType type : ItemType.values()) {
                if (found >= 15) {
                    player.print("\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e \u0431\u044b\u043b\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043e!");
                    break;
                }
                if (blocksOnly && type.getID() > 255 || itemsOnly && type.getID() <= 255) continue;
                for (String alias : type.getAliases()) {
                    if (!alias.contains(query)) continue;
                    player.print("#" + type.getID() + " (" + type.getName() + ")");
                    ++found;
                    continue block2;
                }
            }
            if (found == 0) {
                player.printError("\u041f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
            }
            return;
        }
    }

    @Command(aliases={"we", "worldedit"}, desc="\u041a\u043e\u043c\u0430\u043d\u0434\u044b WorldEdit")
    @NestedCommand(value={WorldEditCommands.class})
    @Console
    public void we(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }
}

