/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.expression.ExpressionException;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.StringUtil;
import com.sk89q.worldedit.util.TreeGenerator;

public class GenerationCommands {
    private final WorldEdit we;

    public GenerationCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/hcyl"}, usage="<block> <radius>[,<radius>] [height]", desc="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u043f\u043e\u043b\u044b\u0439 \u0446\u0438\u043b\u0438\u043d\u0434\u0440.", help="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u043f\u043e\u043b\u044b\u0439 \u0446\u0438\u043b\u0438\u043d\u0434\u0440.\n\u0423\u043a\u0430\u0436\u0438\u0442\u0435 2 \u0440\u0430\u0434\u0438\u0443\u0441\u0430 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e(\u0412\u044b\u0441\u043e\u0442\u0430 \u0438 \u0448\u0438\u0440\u0438\u043d\u0430)\n\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u043b\u043b\u0438\u043f\u0441\u043e\u0432\u044b\u0435 \u0446\u0438\u043b\u0438\u043d\u0434\u0440\u044b.\n1-\u0439 \u0440\u0430\u0434\u0438\u0443\u0441 \u0441\u0435\u0432\u0435\u0440/\u044e\u0433, 2-\u0439 \u0440\u0430\u0434\u0438\u0443\u0441 \u0432\u043e\u0441\u0442\u043e\u043a/\u0437\u0430\u043f\u0430\u0434.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hcyl(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusX = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                break;
            }
            case 2: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[1]));
                break;
            }
            default: {
                player.printError("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0434\u043d\u043e \u0438\u043b\u0438 \u0434\u0432\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0430\u0434\u0438\u0443\u0441\u0430.");
                return;
            }
        }
        int height = args.argsLength() > 2 ? args.getInteger(2) : 1;
        this.we.checkMaxRadius(radiusX);
        this.we.checkMaxRadius(radiusZ);
        this.we.checkMaxRadius(height);
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makeCylinder(pos, block, radiusX, radiusZ, height, false);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"/cyl"}, usage="<block> <radius>[,<radius>] [height]", desc="\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0446\u0438\u043b\u0438\u043d\u0434\u0440\u0430.", help="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u0446\u0438\u043b\u0438\u043d\u0434\u0440.\n\u0423\u043a\u0430\u0436\u0438\u0442\u0435 2 \u0440\u0430\u0434\u0438\u0443\u0441\u0430 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e\n\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u044d\u043b\u043b\u0438\u043f\u0441\u043e\u0432\u044b\u0435 \u0446\u0438\u043b\u0438\u043d\u0434\u0440\u044b.\n1-\u0439 \u0440\u0430\u0434\u0438\u0443\u0441 \u0441\u0435\u0432\u0435\u0440/\u044e\u0433, 2-\u0439 \u0440\u0430\u0434\u0438\u0443\u0441 \u0432\u043e\u0441\u0442\u043e\u043a/\u0437\u0430\u043f\u0430\u0434.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.cylinder"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void cyl(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusX = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                break;
            }
            case 2: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[1]));
                break;
            }
            default: {
                player.printError("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0434\u043d\u043e \u0438\u043b\u0438 \u0434\u0432\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0430\u0434\u0438\u0443\u0441\u0430.");
                return;
            }
        }
        int height = args.argsLength() > 2 ? args.getInteger(2) : 1;
        this.we.checkMaxRadius(radiusX);
        this.we.checkMaxRadius(radiusZ);
        this.we.checkMaxRadius(height);
        Vector pos = session.getPlacementPosition(player);
        int affected = editSession.makeCylinder(pos, block, radiusX, radiusZ, height, true);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"/hsphere"}, usage="<block> <radius>[,<radius>,<radius>] [raised?]", desc="\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u043f\u043e\u043b\u043e\u0439 \u0441\u0444\u0435\u0440\u044b.", help="\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u043f\u043e\u043b\u0443\u044e \u0441\u0444\u0435\u0440\u0443.\n\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0440\u0438 \u0440\u0430\u0434\u0438\u0443\u0441\u0430 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e\n\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u043b\u043b\u0438\u043f\u0441\u043e\u0438\u0434.\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0440\u0430\u0434\u0438\u0443\u0441\u043e\u0432 \u044d\u043b\u043b\u0438\u043f\u0441\u043e\u0438\u0434\u0430\n\u044d\u0442\u043e \u0441\u0435\u0432\u0435\u0440/\u044e\u0433, \u0432\u0432\u0435\u0440\u0445/\u0432\u043d\u0438\u0437, \u0432\u043e\u0441\u0442\u043e\u043a/\u0437\u0430\u043f\u0430\u0434.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hsphere(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusY;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusY = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusX = radiusZ;
                break;
            }
            case 3: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusY = Math.max(1.0, Double.parseDouble(radiuses[1]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[2]));
                break;
            }
            default: {
                player.printError("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0434\u043d\u043e \u0438\u043b\u0438 \u0442\u0440\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0430\u0434\u0438\u0443\u0441\u0430.");
                return;
            }
        }
        this.we.checkMaxRadius(radiusX);
        this.we.checkMaxRadius(radiusY);
        this.we.checkMaxRadius(radiusZ);
        boolean raised = args.argsLength() > 2 ? args.getString(2).equalsIgnoreCase("true") || args.getString(2).equalsIgnoreCase("yes") : false;
        Vector pos = session.getPlacementPosition(player);
        if (raised) {
            pos = pos.add(0.0, radiusY, 0.0);
        }
        int affected = editSession.makeSphere(pos, block, radiusX, radiusY, radiusZ, false);
        player.findFreePosition();
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"/sphere"}, usage="<block> <radius>[,<radius>,<radius>] [raised?]", desc="\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u0444\u0435\u0440\u044b.", help="\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u0441\u0444\u0435\u0440\u0443.\n\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0442\u0440\u0438 \u0440\u0430\u0434\u0443\u0441\u0430 \u0447\u0435\u0440\u0435\u0437 \u0437\u0430\u043f\u044f\u0442\u0443\u044e,\n\u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u043b\u043b\u0438\u043f\u0441\u043e\u0438\u0434. \u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0440\u0430\u0434\u0438\u0443\u0441\u043e\u0432 \u044d\u043b\u043b\u0438\u043f\u0441\u043e\u0438\u0434\u0430\n\u044d\u0442\u043e \u0441\u0435\u0432\u0435\u0440/\u044e\u0433, \u0432\u0432\u0435\u0440\u0445/\u0432\u043d\u0438\u0437, \u0432\u043e\u0441\u0442\u043e\u043a/\u0437\u0430\u043f\u0430\u0434.", min=2, max=3)
    @CommandPermissions(value={"worldedit.generation.sphere"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void sphere(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radiusX;
        double radiusY;
        double radiusZ;
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        String[] radiuses = args.getString(1).split(",");
        switch (radiuses.length) {
            case 1: {
                radiusY = radiusZ = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusX = radiusZ;
                break;
            }
            case 3: {
                radiusX = Math.max(1.0, Double.parseDouble(radiuses[0]));
                radiusY = Math.max(1.0, Double.parseDouble(radiuses[1]));
                radiusZ = Math.max(1.0, Double.parseDouble(radiuses[2]));
                break;
            }
            default: {
                player.printError("\u0412\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043e\u0434\u043d\u043e \u0438\u043b\u0438 \u0442\u0440\u0438 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0440\u0430\u0434\u0438\u0443\u0441\u0430.");
                return;
            }
        }
        this.we.checkMaxRadius(radiusX);
        this.we.checkMaxRadius(radiusY);
        this.we.checkMaxRadius(radiusZ);
        boolean raised = args.argsLength() > 2 ? args.getString(2).equalsIgnoreCase("true") || args.getString(2).equalsIgnoreCase("yes") : false;
        Vector pos = session.getPlacementPosition(player);
        if (raised) {
            pos = pos.add(0.0, radiusY, 0.0);
        }
        int affected = editSession.makeSphere(pos, block, radiusX, radiusY, radiusZ, true);
        player.findFreePosition();
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"forestgen"}, usage="[size] [type] [density]", desc="\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u043b\u0435\u0441.", min=0, max=3)
    @CommandPermissions(value={"worldedit.generation.forest"})
    @Logging(value=Logging.LogMode.POSITION)
    public void forestGen(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double density;
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 10;
        TreeGenerator.TreeType type = args.argsLength() > 1 ? TreeGenerator.lookup(args.getString(1)) : TreeGenerator.TreeType.TREE;
        double d = density = args.argsLength() > 2 ? args.getDouble(2) / 100.0 : 0.05;
        if (type == null) {
            player.printError("\u0422\u0438\u043f\u0430 \u0434\u0435\u0440\u0435\u0432\u044c\u0435\u0432 '" + args.getString(1) + "' \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            return;
        }
        int affected = editSession.makeForest(session.getPlacementPosition(player), size, density, new TreeGenerator(type));
        player.print(affected + " " + StringUtil.plural(affected, "\u0434\u0435\u0440\u0435\u0432\u043e \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0434\u0435\u0440\u0435\u0432\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0434\u0435\u0440\u0435\u0432\u044c\u0435\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"pumpkins"}, usage="[size]", desc="\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u0442\u044b\u043a\u0432\u044b", min=0, max=1)
    @CommandPermissions(value={"worldedit.generation.pumpkins"})
    @Logging(value=Logging.LogMode.POSITION)
    public void pumpkins(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 10;
        int affected = editSession.makePumpkinPatches(session.getPlacementPosition(player), size);
        player.print(affected + " " + StringUtil.plural(affected, "\u0442\u044b\u043a\u0432\u0430 \u0431\u044b\u043b\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0442\u044b\u043a\u0432\u044b \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0442\u044b\u043a\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"/pyramid"}, usage="<block> <size>", desc="\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u043f\u0438\u0440\u0430\u043c\u0438\u0434\u0443.", min=2, max=2)
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void pyramid(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        int size = Math.max(1, args.getInteger(1));
        Vector pos = session.getPlacementPosition(player);
        this.we.checkMaxRadius(size);
        int affected = editSession.makePyramid(pos, block, size, true);
        player.findFreePosition();
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"/hpyramid"}, usage="<block> <size>", desc="\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u043f\u043e\u043b\u0443\u044e \u043f\u0438\u0440\u0430\u043c\u0438\u0434\u0443.", min=2, max=2)
    @CommandPermissions(value={"worldedit.generation.pyramid"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void hpyramid(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern block = this.we.getBlockPattern(player, args.getString(0));
        int size = Math.max(1, args.getInteger(1));
        Vector pos = session.getPlacementPosition(player);
        this.we.checkMaxRadius(size);
        int affected = editSession.makePyramid(pos, block, size, false);
        player.findFreePosition();
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
    }

    @Command(aliases={"/generate", "/gen", "/g"}, usage="<block> <expression>", desc="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u0444\u043e\u0440\u043c\u0443 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0444\u043e\u0440\u043c\u0443\u043b\u043e\u0439.", help="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u0444\u043e\u0440\u043c\u0443 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0444\u043e\u0440\u043c\u0443\u043b\u043e\u0439, \u043a\u043e\u0442\u043e\u0440\u0430\u044f \n\u0432\u0435\u0440\u043d\u0435\u0442 \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0447\u0438\u0441\u043b\u0430(\u0438\u0441\u0442\u0438\u043d\u0430), \u0435\u0441\u043b\u0438 \u0442\u043e\u0447\u043a\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432\u043d\u0443\u0442\u0440\u0438 \u0444\u043e\u0440\u043c\u044b \n\u041f\u043e \u0436\u0435\u043b\u0430\u043d\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u0442\u0438\u043f/\u0434\u0430\u043d\u043d\u044b\u0435 \u043d\u0430 \u043d\u0443\u0436\u043d\u044b\u0439 \u0431\u043b\u043e\u043a..\n\u0424\u043b\u0430\u0433\u0438:\n  -h \u0434\u043b\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u043f\u043e\u043b\u043e\u0439 \u0444\u043e\u0440\u043c\u044b\n  -r \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442 Minecraft\n  -o \u043a\u0430\u043a \u0444\u043b\u0430\u0433 -r, \u043a\u0440\u043e\u043c\u0435 \u0441\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u043e\u0442 \u0440\u0430\u0437\u043c\u0435\u0449\u0435\u043d\u0438\u044f.\n  -c \u043a\u0430\u043a \u0444\u043b\u0430\u0433 -r, \u043a\u0440\u043e\u043c\u0435 \u0432\u044b\u0431\u043e\u0440\u0430 \u0441\u043c\u0435\u0449\u0435\u043d\u0438\u044f \u0446\u0435\u043d\u0442\u0440\u0430.\n\u0415\u0441\u043b\u0438 \u043d\u0435\u0442 \u043d\u0438 \u0444\u043b\u0430\u0433\u0430 -r, \u043d\u0438 -o, \u0442\u043e \u0432\u044b\u0431\u043e\u0440 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0434\u043e -1 .. 1\n\u0422\u0430\u043a\u0436\u0435 \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043d\u0430 tinyurl.com/wesyntax.", flags="hroc", min=2, max=-1)
    @CommandPermissions(value={"worldedit.generation.shape"})
    @Logging(value=Logging.LogMode.ALL)
    public void generate(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector min;
        Vector unit;
        Vector zero;
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        Region region = session.getSelection(player.getWorld());
        boolean hollow = args.hasFlag('h');
        String expression = args.getJoinedStrings(1);
        if (args.hasFlag('r')) {
            zero = Vector.ZERO;
            unit = Vector.ONE;
        } else if (args.hasFlag('o')) {
            zero = session.getPlacementPosition(player);
            unit = Vector.ONE;
        } else if (args.hasFlag('c')) {
            min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            zero = max.add(min).multiply(0.5);
            unit = Vector.ONE;
        } else {
            min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit = unit.setX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.setY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.setZ(1.0);
            }
        }
        try {
            int affected = editSession.makeShape(region, zero, unit, pattern, expression, hollow);
            player.findFreePosition();
            player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e") + ".");
        }
        catch (ExpressionException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/generatebiome", "/genbiome", "/gb"}, usage="<block> <expression>", desc="\u0423\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0440\u0435\u0433\u0438\u043e\u043d \u0441\u043e\u0433\u043b\u0430\u0441\u043d\u043e \u0444\u043e\u0440\u043c\u0443\u043b\u0435.", help="Generates a shape according to a formula that is expected to\nreturn positive numbers (true) if the point is inside the shape\nOptionally set type/data to the desired block.\nFlags:\n  -h to generate a hollow shape\n  -r to use raw minecraft coordinates\n  -o is like -r, except offset from placement.\n  -c is like -r, except offset selection center.\nIf neither -r nor -o is given, the selection is mapped to -1..1\nSee also tinyurl.com/wesyntax.", flags="hroc", min=2, max=-1)
    @CommandPermissions(value={"worldedit.generation.shape", "worldedit.biome.set"})
    @Logging(value=Logging.LogMode.ALL)
    public void generateBiome(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector min;
        Vector unit;
        Vector zero;
        BiomeType target = this.we.getServer().getBiomes().get(args.getString(0));
        Region region = session.getSelection(player.getWorld());
        boolean hollow = args.hasFlag('h');
        String expression = args.getJoinedStrings(1);
        if (args.hasFlag('r')) {
            zero = Vector.ZERO;
            unit = Vector.ONE;
        } else if (args.hasFlag('o')) {
            zero = session.getPlacementPosition(player);
            unit = Vector.ONE;
        } else if (args.hasFlag('c')) {
            min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            zero = max.add(min).multiply(0.5);
            unit = Vector.ONE;
        } else {
            min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit = unit.setX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.setY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.setZ(1.0);
            }
        }
        try {
            int affected = editSession.makeBiomeShape(region, zero, unit, target, expression, hollow);
            player.findFreePosition();
            player.print("\u0411\u0438\u043e\u043c \u0438\u0437\u043c\u0435\u043d\u0435\u043d \u043d\u0430 " + target.getName() + ". " + affected + " " + StringUtil.plural(affected, "\u043a\u043e\u043b\u043e\u043d\u043a\u0430 \u0431\u044b\u043b\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430", "\u043a\u043e\u043b\u043e\u043d\u043a\u0438 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u043a\u043e\u043b\u043e\u043d\u043e\u043a \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
        }
        catch (ExpressionException e) {
            player.printError(e.getMessage());
        }
    }
}

