/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;

public class HistoryCommands {
    private final WorldEdit we;

    public HistoryCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/undo", "undo"}, usage="[times] [player]", desc="\u041e\u0442\u043c\u0435\u043d\u044f\u0435\u0442 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435", min=0, max=2)
    @CommandPermissions(value={"worldedit.history.undo"})
    public void undo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int times = Math.max(1, args.getInteger(0, 1));
        for (int i = 0; i < times; ++i) {
            EditSession undone;
            if (args.argsLength() < 2) {
                undone = session.undo(session.getBlockBag(player), player);
            } else {
                player.checkPermission("worldedit.history.undo.other");
                LocalSession sess = this.we.getSession(args.getString(1));
                if (sess == null) {
                    player.printError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0441\u0435\u0441\u0441\u0438\u044e \u0434\u043b\u044f " + args.getString(1));
                    break;
                }
                undone = sess.undo(session.getBlockBag(player), player);
            }
            if (undone == null) {
                player.printError("\u041e\u0442\u043c\u0435\u043d\u044f\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e.");
                break;
            }
            player.print("\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u043e.");
            this.we.flushBlockBag(player, undone);
        }
    }

    @Command(aliases={"/redo", "redo"}, usage="[times] [player]", desc="\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0435 (\u0438\u0437 \u0438\u0441\u0442\u043e\u0440\u0438\u0438)", min=0, max=2)
    @CommandPermissions(value={"worldedit.history.redo"})
    public void redo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int times = Math.max(1, args.getInteger(0, 1));
        for (int i = 0; i < times; ++i) {
            EditSession redone;
            if (args.argsLength() < 2) {
                redone = session.redo(session.getBlockBag(player), player);
            } else {
                player.checkPermission("worldedit.history.redo.other");
                LocalSession sess = this.we.getSession(args.getString(1));
                if (sess == null) {
                    player.printError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0441\u0435\u0441\u0441\u0438\u044e \u0434\u043b\u044f " + args.getString(1));
                    break;
                }
                redone = sess.redo(session.getBlockBag(player), player);
            }
            if (redone != null) {
                player.print("\u0423\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.");
                this.we.flushBlockBag(player, redone);
                continue;
            }
            player.printError("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0438\u0432\u0430\u0442\u044c \u043d\u0435\u0447\u0435\u0433\u043e.");
        }
    }

    @Command(aliases={"/clearhistory", "clearhistory"}, usage="", desc="\u041e\u0447\u0438\u0449\u0430\u0435\u0442 \u0412\u0430\u0448\u0443 \u0438\u0441\u0442\u043e\u0440\u0438\u044e", min=0, max=0)
    @CommandPermissions(value={"worldedit.history.clear"})
    public void clearHistory(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.clearHistory();
        player.print("\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u0447\u0438\u0449\u0435\u043d\u0430.");
    }
}

