/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.util.StringUtil;

public class NavigationCommands {
    private final WorldEdit we;

    public NavigationCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"unstuck", "!"}, usage="", desc="\u0412\u044b\u0431\u0440\u0430\u0442\u044c\u0441\u044f \u0438\u0437 \u0431\u043b\u043e\u043a\u0430.", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.unstuck"})
    public void unstuck(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("\u0421\u0432\u043e\u0431\u043e\u0434\u0435\u043d!");
        player.findFreePosition();
    }

    @Command(aliases={"ascend", "asc"}, usage="[# of levels]", desc="\u041f\u043e\u0434\u043d\u044f\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u0442\u0430\u0436 \u0432\u044b\u0448\u0435.", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.ascend"})
    public void ascend(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int ascentLevels;
        int levelsToAscend = 0;
        levelsToAscend = args.argsLength() == 0 ? 1 : args.getInteger(0);
        for (ascentLevels = 1; player.ascendLevel() && levelsToAscend != ascentLevels; ++ascentLevels) {
        }
        if (ascentLevels == 0) {
            player.printError("\u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u0432\u044b\u0448\u0435, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0432\u044b \u043d\u0430\u0448\u043b\u0438.");
        } else {
            player.print(ascentLevels != 1 ? "\u0412\u044b \u043f\u043e\u0434\u043d\u044f\u043b\u0438\u0441\u044c \u043d\u0430 " + Integer.toString(ascentLevels) + " " + StringUtil.plural(ascentLevels, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c", "\u0443\u0440\u043e\u0432\u043d\u044f", "\u0443\u0440\u043e\u0432\u043d\u0435\u0439") + "." : "\u041f\u043e\u0434\u043d\u044f\u0442\u044c\u0441\u044f \u043d\u0430 \u0443\u0440\u043e\u0432\u043d\u0438(\u0432\u0435\u043d\u044c).");
        }
    }

    @Command(aliases={"descend", "desc"}, usage="[# of floors]", desc="\u041f\u043e\u0434\u043d\u044f\u0442\u044c\u0441\u044f \u043d\u0430 \u044d\u0442\u0430\u0436 \u043d\u0438\u0436\u0435", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.descend"})
    public void descend(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int descentLevels;
        int levelsToDescend = 0;
        levelsToDescend = args.argsLength() == 0 ? 1 : args.getInteger(0);
        for (descentLevels = 1; player.descendLevel() && levelsToDescend != descentLevels; ++descentLevels) {
        }
        if (descentLevels == 0) {
            player.printError("\u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u043d\u0438\u0436\u0435, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0432\u044b \u043d\u0430\u0448\u043b\u0438.");
        } else {
            player.print(descentLevels != 1 ? "\u0412\u044b \u043e\u043f\u0443\u0441\u0442\u0438\u043b\u0438\u0441\u044c \u043d\u0430 " + Integer.toString(descentLevels) + " \u0443\u0440\u043e\u0432\u043d\u0435\u0439(\u043d\u044f)." : "\u041e\u043f\u0443\u0441\u0442\u0438\u0442\u044c\u0441\u044f \u043d\u0430 \u0443\u0440\u043e\u0432\u043d\u0438(\u0432\u0435\u043d\u044c).");
        }
    }

    @Command(aliases={"ceil"}, usage="[clearance]", desc="\u041f\u0435\u0440\u0435\u0439\u0442\u0438 \u043d\u0430 \u043f\u043e\u0442\u043e\u043b\u043e\u043a", flags="g", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.ceiling"})
    @Logging(value=Logging.LogMode.POSITION)
    public void ceiling(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        boolean alwaysGlass;
        int clearence = args.argsLength() > 0 ? Math.max(0, args.getInteger(0)) : 0;
        if (player.ascendToCeiling(clearence, alwaysGlass = args.hasFlag('g'))) {
            player.print("\u0423\u0438\u0438\u0438\u0438!");
        } else {
            player.printError("\u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0432\u044b \u043d\u0430\u0448\u043b\u0438.");
        }
    }

    @Command(aliases={"thru"}, usage="", desc="\u041f\u0440\u043e\u0445\u043e\u0434\u0438\u0442\u044c \u0441\u043a\u0432\u043e\u0437\u044c \u0441\u0442\u0435\u043d\u044b", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.thru.command"})
    public void thru(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (player.passThroughForwardWall(6)) {
            player.print("\u0423\u0438\u0438\u0438\u0438!");
        } else {
            player.printError("\u0421\u0432\u043e\u0431\u043e\u0434\u043d\u043e\u0433\u043e \u043c\u0435\u0441\u0442\u0430 \u043f\u0435\u0440\u0435\u0434 \u0412\u0430\u043c\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
        }
    }

    @Command(aliases={"jumpto", "j"}, usage="", desc="\u0422\u0435\u043b\u0435\u043f\u043e\u0440\u0442 \u043d\u0430 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.jumpto.command"})
    public void jumpTo(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getSolidBlockTrace(300);
        if (pos != null) {
            player.findFreePosition(pos);
            player.print("\u0411\u0443\u043c!");
        } else {
            player.printError("\u0411\u043b\u043e\u043a\u043e\u0432 \u0432 \u043f\u043e\u043b\u0435 \u0437\u0440\u0435\u043d\u0438\u044f \u043d\u0435\u0442!");
        }
    }

    @Command(aliases={"up"}, usage="<block>", desc="\u041f\u043e\u0434\u043d\u044f\u0442\u044c\u0441\u044f \u0432\u0432\u0435\u0440\u0445 \u043d\u0430 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435", flags="g", min=1, max=1)
    @CommandPermissions(value={"worldedit.navigation.up"})
    @Logging(value=Logging.LogMode.POSITION)
    public void up(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        boolean alwaysGlass;
        int distance = args.getInteger(0);
        if (player.ascendUpwards(distance, alwaysGlass = args.hasFlag('g'))) {
            player.print("\u0423\u0438\u0438\u0438\u0438!");
        } else {
            player.printError("\u0412\u0430\u0441 \u0443\u0434\u0430\u0440\u0438\u043b\u043e \u0447\u0442\u043e-\u0442\u043e \u0432\u044b\u0448\u0435 \u0412\u0430\u0441.");
        }
    }
}

