/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.HeightMap;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.expression.ExpressionException;
import com.sk89q.worldedit.filtering.GaussianKernel;
import com.sk89q.worldedit.filtering.HeightMapFilter;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.SingleBlockPattern;
import com.sk89q.worldedit.regions.ConvexPolyhedralRegion;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.util.StringUtil;
import java.util.ArrayList;
import java.util.Set;

public class RegionCommands {
    private final WorldEdit we;

    public RegionCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/set"}, usage="<block>", desc="\u0417\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0431\u043b\u043e\u043a\u0430\u043c\u0438.", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.set"})
    @Logging(value=Logging.LogMode.REGION)
    public void set(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        int affected = pattern instanceof SingleBlockPattern ? editSession.setBlocks(session.getSelection(player.getWorld()), ((SingleBlockPattern)pattern).getBlock()) : editSession.setBlocks(session.getSelection(player.getWorld()), pattern);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/line"}, usage="<block> [thickness]", desc="\u0420\u0438\u0441\u0443\u0435\u0442 \u043b\u0438\u043d\u0438\u044e \u043c\u0435\u0436\u0434\u0443 \u0443\u0433\u043b\u0430\u043c\u0438 \u043a\u0443\u0431\u043e\u0438\u0434\u0430", help="\u0420\u0438\u0441\u0443\u0435\u0442 \u043b\u0438\u043d\u0438\u044e \u043c\u0435\u0436\u0434\u0443 \u0443\u0433\u043b\u0430\u043c\u0438 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u043a\u0443\u0431\u043e\u0438\u0434\u0430.\n\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043a \u043a\u0443\u0431\u043e\u0438\u0434\u0443.\n\u0424\u043b\u0430\u0433\u0438:\n  -h \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u043e\u0432\u0435\u0440\u0445\u043d\u043e\u0441\u0442\u044c", flags="h", min=1, max=2)
    @CommandPermissions(value={"worldedit.region.line"})
    @Logging(value=Logging.LogMode.REGION)
    public void line(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(session.getSelectionWorld());
        if (!(region instanceof CuboidRegion)) {
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0440\u0435\u0433\u0438\u043e\u043d\u0430");
            return;
        }
        if (args.argsLength() >= 2 && args.getDouble(1) < 0.0) {
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0442\u043e\u043b\u0449\u0438\u043d\u0430. \u041d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f.");
            return;
        }
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        CuboidRegion cuboidregion = (CuboidRegion)region;
        Vector pos1 = cuboidregion.getPos1();
        Vector pos2 = cuboidregion.getPos2();
        int blocksChanged = editSession.drawLine(pattern, pos1, pos2, args.argsLength() < 2 ? 0.0 : args.getDouble(1), !args.hasFlag('h'));
        player.print(blocksChanged + " " + StringUtil.plural(blocksChanged, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/curve"}, usage="<block> [thickness]", desc="\u0420\u0438\u0441\u0443\u0435\u0442 \u043a\u0440\u0438\u0432\u0443\u044e \u0447\u0435\u0440\u0435\u0437 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0442\u043e\u0447\u043a\u0438.", help="\u0420\u0438\u0441\u0443\u0435\u0442 \u043a\u0440\u0438\u0432\u0443\u044e \u0447\u0435\u0440\u0435\u0437 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0442\u043e\u0447\u043a\u0438.\n\u041c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u0438\u043c\u0435\u0440\u0435\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u043a \u043f\u043e\u043b\u0438\u0433\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u043c\u0443 \u0432\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044e.\n\u0424\u043b\u0430\u0433\u0438:\n  -h \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0431\u043e\u043b\u043e\u0447\u043a\u0443", flags="h", min=1, max=2)
    @CommandPermissions(value={"worldedit.region.curve"})
    @Logging(value=Logging.LogMode.REGION)
    public void curve(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(session.getSelectionWorld());
        if (!(region instanceof ConvexPolyhedralRegion)) {
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0442\u0438\u043f \u0440\u0435\u0433\u0438\u043e\u043d\u0430");
            return;
        }
        if (args.argsLength() >= 2 && args.getDouble(1) < 0.0) {
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0442\u043e\u043b\u0449\u0438\u043d\u0430. \u041d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043e\u0442\u0440\u0438\u0446\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f.");
            return;
        }
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        ConvexPolyhedralRegion cpregion = (ConvexPolyhedralRegion)region;
        ArrayList<Vector> vectors = new ArrayList<Vector>(cpregion.getVertices());
        int blocksChanged = editSession.drawSpline(pattern, vectors, 0.0, 0.0, 0.0, 10.0, args.argsLength() < 2 ? 0.0 : args.getDouble(1), !args.hasFlag('h'));
        player.print(blocksChanged + " " + StringUtil.plural(blocksChanged, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/replace", "/re", "/rep"}, usage="[from-block] <to-block>", desc="\u0417\u0430\u043c\u0435\u043d\u044f\u0435\u0442 \u0432\u0441\u0435 \u0431\u043b\u043e\u043a\u0438 \u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u0438\u0435", flags="f", min=1, max=2)
    @CommandPermissions(value={"worldedit.region.replace"})
    @Logging(value=Logging.LogMode.REGION)
    public void replace(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern to;
        Set<BaseBlock> from;
        if (args.argsLength() == 1) {
            from = null;
            to = this.we.getBlockPattern(player, args.getString(0));
        } else {
            from = this.we.getBlocks(player, args.getString(0), true, !args.hasFlag('f'));
            to = this.we.getBlockPattern(player, args.getString(1));
        }
        int affected = to instanceof SingleBlockPattern ? editSession.replaceBlocks(session.getSelection(player.getWorld()), from, ((SingleBlockPattern)to).getBlock()) : editSession.replaceBlocks(session.getSelection(player.getWorld()), from, to);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0437\u0430\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0437\u0430\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0437\u0430\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/overlay"}, usage="<block>", desc="\u041d\u0430\u043a\u043b\u0430\u0434\u044b\u0432\u0430\u0435\u0442 \u0431\u043b\u043e\u043a\u0438 \u043f\u043e\u0432\u0435\u0440\u0445 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.overlay"})
    @Logging(value=Logging.LogMode.REGION)
    public void overlay(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pat = this.we.getBlockPattern(player, args.getString(0));
        Region region = session.getSelection(player.getWorld());
        int affected = 0;
        affected = pat instanceof SingleBlockPattern ? editSession.overlayCuboidBlocks(region, ((SingleBlockPattern)pat).getBlock()) : editSession.overlayCuboidBlocks(region, pat);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u043d\u0430\u043b\u043e\u0436\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u043d\u0430\u043b\u043e\u0436\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u043d\u0430\u043b\u043e\u0436\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/center", "/middle"}, usage="<block>", desc="\u0417\u0430\u0434\u0430\u0442\u044c \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u044b\u0435 \u0431\u043b\u043e\u043a(\u0438)", min=1, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.region.center"})
    public void center(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        Region region = session.getSelection(player.getWorld());
        int affected = editSession.center(region, pattern);
        player.print("\u0426\u0435\u043d\u0442\u0440 \u0437\u0430\u0434\u0430\u043d (" + affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ")");
    }

    @Command(aliases={"/naturalize"}, usage="", desc="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 3 \u0441\u043b\u043e\u044f \u0433\u0440\u044f\u0437\u0438 \u0441\u0432\u0435\u0440\u0445\u0443 \u0438 \u043a\u0430\u043c\u0435\u043d\u044c \u043f\u043e\u0434 \u043d\u0435\u0439.", min=0, max=0)
    @CommandPermissions(value={"worldedit.region.naturalize"})
    @Logging(value=Logging.LogMode.REGION)
    public void naturalize(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        int affected = editSession.naturalizeCuboidBlocks(region);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/walls"}, usage="<block>", desc="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u0441\u0442\u0435\u043d\u044b \u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.walls"})
    @Logging(value=Logging.LogMode.REGION)
    public void walls(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        Region region = session.getSelection(player.getWorld());
        int affected = !(region instanceof CuboidRegion) ? editSession.makeWalls(region, pattern) : (pattern instanceof SingleBlockPattern ? editSession.makeCuboidWalls(region, ((SingleBlockPattern)pattern).getBlock()) : editSession.makeCuboidWalls(region, pattern));
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/faces", "/outline"}, usage="<block>", desc="\u0421\u0442\u0440\u043e\u0438\u0442 \u0441\u0442\u0435\u043d\u044b, \u043f\u043e\u043b \u0438 \u043f\u043e\u0442\u043e\u043b\u043e\u043a \u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", min=1, max=1)
    @CommandPermissions(value={"worldedit.region.faces"})
    @Logging(value=Logging.LogMode.REGION)
    public void faces(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        Region region = session.getSelection(player.getWorld());
        int affected = !(region instanceof CuboidRegion) ? editSession.makeFaces(region, pattern) : (pattern instanceof SingleBlockPattern ? editSession.makeCuboidFaces(region, ((SingleBlockPattern)pattern).getBlock()) : editSession.makeCuboidFaces(region, pattern));
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/smooth"}, usage="[iterations]", flags="n", desc="\u0421\u0433\u043b\u0430\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u0432\u043e\u0437\u0432\u044b\u0448\u0435\u043d\u043d\u043e\u0441\u0442\u0435\u0439 \u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.", help="\u0421\u0433\u043b\u0430\u0436\u0438\u0432\u0430\u0435\u0442 \u0432\u043e\u0437\u0432\u044b\u0448\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.\n\u0424\u043b\u0430\u0433 -n \u043f\u0440\u0438\u043c\u0435\u043d\u044f\u0435\u0442 \u0441\u0433\u043b\u0430\u0436\u0438\u0432\u0430\u043d\u0438\u0435 \u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0430 \u043d\u0430\u0442\u0443\u0440\u0430\u043b\u044c\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438(\u043f\u0440\u0438\u0440\u043e\u0434\u0430).", min=0, max=1)
    @CommandPermissions(value={"worldedit.region.smooth"})
    @Logging(value=Logging.LogMode.REGION)
    public void smooth(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int iterations = 1;
        if (args.argsLength() > 0) {
            iterations = args.getInteger(0);
        }
        HeightMap heightMap = new HeightMap(editSession, session.getSelection(player.getWorld()), args.hasFlag('n'));
        HeightMapFilter filter = new HeightMapFilter(new GaussianKernel(5, 1.0));
        int affected = heightMap.applyFilter(filter, iterations);
        player.print("\u0412\u044b\u0441\u043e\u0442\u044b \u0441\u0433\u043b\u0430\u0436\u0435\u043d\u044b. " + affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/move"}, usage="[count] [direction] [leave-id]", flags="s", desc="\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", help="\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0430\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.\n\u0424\u043b\u0430\u0433 -s \u0441\u043c\u0435\u0449\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u043d\u0430 \u043d\u0443\u0436\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e.\n\u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0432 \u0441\u0442\u0430\u0440\u043e\u043c \u043c\u0435\u0441\u0442\u0435 \u0441 <id>.", min=0, max=3)
    @CommandPermissions(value={"worldedit.region.move"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public void move(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int count = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 1;
        Vector dir = this.we.getDirection(player, args.argsLength() > 1 ? args.getString(1).toLowerCase() : "me");
        BaseBlock replace = args.argsLength() > 2 ? this.we.getBlock(player, args.getString(2)) : new BaseBlock(0);
        int affected = editSession.moveRegion(session.getSelection(player.getWorld()), dir, count, true, replace);
        if (args.hasFlag('s')) {
            try {
                Region region = session.getSelection(player.getWorld());
                region.shift(dir.multiply(count));
                session.getRegionSelector(player.getWorld()).learnChanges();
                session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            }
            catch (RegionOperationException e) {
                player.printError(e.getMessage());
            }
        }
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/stack"}, usage="[count] [direction]", flags="sa", desc="\u041f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u0438\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", help="\u041f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.\n\u0424\u043b\u0430\u0433\u0438:\n  -s \u0441\u043c\u0435\u0449\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u043d\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044e\u044e \u043a\u043e\u043f\u0438\u044e\n  -a \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u0442 \u0431\u043b\u043e\u043a\u0438 \u0432\u043e\u0437\u0434\u0443\u0445\u0430.", min=0, max=2)
    @CommandPermissions(value={"worldedit.region.stack"})
    @Logging(value=Logging.LogMode.ORIENTATION_REGION)
    public void stack(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int count = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 1;
        Vector dir = this.we.getDiagonalDirection(player, args.argsLength() > 1 ? args.getString(1).toLowerCase() : "me");
        int affected = editSession.stackCuboidRegion(session.getSelection(player.getWorld()), dir, count, !args.hasFlag('a'));
        if (args.hasFlag('s')) {
            try {
                Region region = session.getSelection(player.getWorld());
                Vector size = region.getMaximumPoint().subtract(region.getMinimumPoint());
                Vector shiftVector = dir.multiply((double)count * (Math.abs(dir.dot(size)) + 1.0));
                region.shift(shiftVector);
                session.getRegionSelector(player.getWorld()).learnChanges();
                session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            }
            catch (RegionOperationException e) {
                player.printError(e.getMessage());
            }
        }
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ". \u041e\u0442\u043c\u0435\u043d\u0430 \u0441 \u043f\u043e\u043c\u043e\u0449\u044c\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u044b //undo");
    }

    @Command(aliases={"/regen"}, usage="", desc="\u0420\u0435\u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0433\u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", help="\u0420\u0435\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.\n\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u043c\u043e\u0436\u0435\u0442 \u043f\u043e\u0432\u043b\u0438\u044f\u0442\u044c \u043d\u0430 \u0432\u0435\u0449\u0438 \u0432\u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438,\n\u0435\u0441\u043b\u0438 \u043e\u043d\u0438 \u043d\u0430\u0445\u043e\u0434\u044f\u0442\u0441\u044f \u0432 \u043e\u0434\u043d\u043e\u043c \u0447\u0430\u043d\u043a\u0435.", min=0, max=0)
    @CommandPermissions(value={"worldedit.regen"})
    @Logging(value=Logging.LogMode.REGION)
    public void regenerateChunk(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        Mask mask = session.getMask();
        session.setMask(null);
        player.getWorld().regenerate(region, editSession);
        session.setMask(mask);
        player.print("\u0420\u0435\u0433\u0438\u043e\u043d \u0440\u0435\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d.");
    }

    @Command(aliases={"/deform"}, usage="<expression>", desc="\u0418\u0441\u043a\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 \u0441 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c.", help="\u0418\u0441\u043a\u0430\u0436\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0441 \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c\n\u0412\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u0431\u043b\u043e\u043a\u0430, \u0438 \n\u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0445 x, y, r, \u0447\u0442\u043e\u0431\u044b \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u0431\u043b\u043e\u043a\u0438\n\u0434\u043b\u044f \u0438\u0437\u0432\u043b\u0435\u0447\u0435\u043d\u0438\u044f. \u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u0442\u0430\u043a\u0436\u0435 tinyurl.com/wesyntax.", flags="ro", min=1, max=-1)
    @CommandPermissions(value={"worldedit.region.deform"})
    @Logging(value=Logging.LogMode.ALL)
    public void deform(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector unit;
        Vector zero;
        Region region = session.getSelection(player.getWorld());
        String expression = args.getJoinedStrings(0);
        if (args.hasFlag('r')) {
            zero = Vector.ZERO;
            unit = Vector.ONE;
        } else if (args.hasFlag('o')) {
            zero = session.getPlacementPosition(player);
            unit = Vector.ONE;
        } else {
            Vector min = region.getMinimumPoint();
            Vector max = region.getMaximumPoint();
            unit = max.subtract(zero = max.add(min).multiply(0.5));
            if (unit.getX() == 0.0) {
                unit = unit.setX(1.0);
            }
            if (unit.getY() == 0.0) {
                unit = unit.setY(1.0);
            }
            if (unit.getZ() == 0.0) {
                unit = unit.setZ(1.0);
            }
        }
        try {
            int affected = editSession.deformRegion(region, zero, unit, expression);
            player.findFreePosition();
            player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0431\u044b\u043b \u0434\u0435\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0431\u044b\u043b\u043e \u0434\u0435\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0431\u044b\u043b\u043e \u0434\u0435\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043e") + ".");
        }
        catch (ExpressionException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/hollow"}, usage="[<thickness>[ <block>]]", desc="\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0432\u043f\u0430\u0434\u0438\u043d \u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0445\u0441\u044f \u0432 \u044d\u0442\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", help="\u0421\u043e\u0437\u0434\u0430\u0435\u0442 \u0432\u0430\u0434\u0438\u043d\u044b \u0438\u0437 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432, \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0449\u0438\u0445\u0441\u044f \u0432 \u044d\u0442\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.\n\u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0432\u044b\u0434\u043e\u043b\u0431\u043b\u0435\u043d\u043d\u044b\u0435 \u0447\u0430\u0441\u0442\u0438 \u0431\u043b\u043e\u043a\u0430\u043c\u0438.\n\u0422\u043e\u043b\u0449\u0438\u043d\u0430 \u0438\u0437\u043c\u0435\u0440\u044f\u0435\u0442\u0441\u044f \u043d\u0430 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u041c\u0430\u043d\u0445\u044d\u0442\u0442\u0435\u043d\u0430.", min=0, max=2)
    @CommandPermissions(value={"worldedit.region.hollow"})
    @Logging(value=Logging.LogMode.REGION)
    public void hollow(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int thickness = args.argsLength() >= 1 ? Math.max(1, args.getInteger(0)) : 1;
        Pattern pattern = args.argsLength() >= 2 ? this.we.getBlockPattern(player, args.getString(1)) : new SingleBlockPattern(new BaseBlock(0));
        int affected = editSession.hollowOutRegion(session.getSelection(player.getWorld()), thickness, pattern);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0438\u0437\u043c\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e") + ".");
    }
}

