/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Console;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.FilenameResolutionException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class SchematicCommands {
    private final WorldEdit we;

    public SchematicCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"load", "l"}, usage="[format] <filename>", desc="\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0441\u0445\u0435\u043c\u044b \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430.", help="\u0417\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442 \u0441\u0445\u0435\u043c\u0443 \u0432 \u0431\u0443\u0444\u0435\u0440 \u043e\u0431\u043c\u0435\u043d\u0430.\n\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u043e\u0440\u043c\u0430\u0442\u043e\u0432 \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0437\u043d\u0430\u0442\u044c \u0438\u0437 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \"//schematic formats\"\n\u0415\u0441\u043b\u0438 \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u0435 \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d, WorldEdit \u0431\u0443\u0434\u0435\u0442\n\u043f\u044b\u0442\u0430\u0442\u044c\u0441\u044f \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0445\u0435\u043c\u044b", flags="f", min=1, max=2)
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load"})
    public void load(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        SchematicFormat format;
        String fileName;
        String formatName;
        LocalConfiguration config = this.we.getConfiguration();
        if (args.argsLength() == 1) {
            formatName = null;
            fileName = args.getString(0);
        } else {
            formatName = args.getString(0);
            fileName = args.getString(1);
        }
        File dir = this.we.getWorkingDirectoryFile(config.saveDir);
        File f = this.we.getSafeOpenFile(player, dir, fileName, "schematic", "schematic");
        if (!f.exists()) {
            player.printError("\u0421\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0444\u0430\u0439\u043b " + fileName + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            return;
        }
        SchematicFormat schematicFormat = format = formatName == null ? null : SchematicFormat.getFormat(formatName);
        if (format == null) {
            format = SchematicFormat.getFormat(f);
        }
        if (format == null) {
            player.printError("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0441\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430: " + formatName);
            return;
        }
        if (!format.isOfFormat(f) && !args.hasFlag('f')) {
            player.printError(fileName + " \u043d\u0435 " + format.getName() + " \u0441\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0444\u0430\u0439\u043b!");
            return;
        }
        try {
            String filePath = f.getCanonicalPath();
            String dirPath = dir.getCanonicalPath();
            if (!filePath.substring(0, dirPath.length()).equals(dirPath)) {
                player.printError("\u0421\u0445\u0435\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u0430 \u0438\u043b\u0438 \u043e\u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.");
            } else {
                session.setClipboard(format.load(f));
                WorldEdit.logger.info(player.getName() + " loaded " + filePath);
                player.print("\u0421\u0445\u0435\u043c\u0430 " + fileName + " \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430. \u0412\u0441\u0442\u0430\u0432\u043a\u0430 \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430 //paste");
            }
        }
        catch (DataException e) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435: " + e.getMessage());
        }
        catch (IOException e) {
            player.printError("\u0421\u0445\u0435\u043c\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u0430 \u0438\u043b\u0438 \u043e\u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(aliases={"save", "s"}, usage="[format] <filename>", desc="\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0441\u0445\u0435\u043c\u044b \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430", help="\u0421\u043e\u0445\u0430\u0440\u043d\u044f\u0435\u0442 \u0441\u0445\u0435\u043c\u0443 \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430\n\u0421\u043f\u0438\u0441\u043e\u043a \u0444\u043e\u0440\u043c\u0430\u0442\u043e\u0432 \u0412\u044b \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0437\u043d\u0430\u0442\u044c \u0438\u0437 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \"//schematic formats\"\n", min=1, max=2)
    @CommandPermissions(value={"worldedit.clipboard.save", "worldedit.schematic.save"})
    public void save(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException, CommandException {
        SchematicFormat format;
        LocalConfiguration config = this.we.getConfiguration();
        if (args.argsLength() == 1) {
            if (SchematicFormat.getFormats().size() != 1) {
                player.printError("\u0411\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0444\u043e\u0440\u043c\u0430\u0442\u043e\u0432 \u0441\u0445\u0435\u043c \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b. \u041f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u0443\u043a\u0430\u0436\u0438\u0442\u0435 \u0436\u0435\u043b\u0430\u0435\u043c\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442.");
                return;
            }
            format = SchematicFormat.getFormats().iterator().next();
        } else {
            format = SchematicFormat.getFormat(args.getString(0));
            if (format == null) {
                player.printError("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430: " + args.getString(0));
                return;
            }
        }
        String filename = args.getString(args.argsLength() - 1);
        File dir = this.we.getWorkingDirectoryFile(config.saveDir);
        File f = this.we.getSafeSaveFile(player, dir, filename, "schematic", "schematic");
        if (!dir.exists() && !dir.mkdir()) {
            player.printError("\u041f\u0430\u043f\u043a\u0430 \u0441\u043e \u0441\u0445\u0435\u043c\u0430\u043c\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d\u0430!");
            return;
        }
        try {
            File parent = f.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new CommandException("\u041f\u0430\u043f\u043a\u0430 \u0441\u043e \u0441\u0445\u0435\u043c\u0430\u043c\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d\u0430!");
            }
            format.save(session.getClipboard(), f);
            WorldEdit.logger.info(player.getName() + " \u0441\u043e\u0445\u0440\u0430\u0435\u043d\u043d\u0430 " + f.getCanonicalPath());
            player.print("\u0421\u0445\u0435\u043c\u0430 " + filename + " \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d.");
            return;
        }
        catch (DataException se) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438: " + se.getMessage());
            return;
        }
        catch (IOException e) {
            player.printError("\u0421\u0445\u0435\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0444\u0430\u0439\u043b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0441\u043e\u0437\u0434\u0430\u043d: " + e.getMessage());
        }
    }

    @Command(aliases={"formats", "listformats", "f"}, desc="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0445 \u0444\u043e\u0440\u043c\u0430\u0442\u043e\u0432", max=0)
    @Console
    @CommandPermissions(value={"worldedit.schematic.formats"})
    public void formats(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0444\u043e\u0440\u043c\u0430\u0442\u044b:");
        boolean first = true;
        for (SchematicFormat format : SchematicFormat.getFormats()) {
            StringBuilder builder = new StringBuilder();
            builder.append(format.getName()).append(": ");
            for (String lookupName : format.getLookupNames()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(lookupName);
                first = false;
            }
            first = true;
            player.print(builder.toString());
        }
    }

    @Command(aliases={"list", "all", "ls"}, desc="\u0421\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u0441\u0445\u0435\u043c", max=0, flags="dn", help="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u0441\u0435\u0445 \u0441\u0445\u0435\u043c \u0438\u0437 \u043f\u0430\u043f\u043a\u0438 \u0441\u043e \u0441\u0445\u0435\u043c\u0430\u043c\u0438\n \u0424\u043b\u0430\u0433 -d \u0441\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442 \u043f\u043e \u0434\u0430\u0442\u044b, \u0441\u0442\u0430\u0440\u044b\u0435 \u043f\u0435\u0440\u0432\u0435\u0435\n -n \u0441\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u0442 \u043f\u043e \u0434\u0430\u0442\u0435, \u043d\u043e\u0432\u044b\u0435 \u043f\u0435\u0440\u0432\u0435\u0435\n")
    @Console
    @CommandPermissions(value={"worldedit.schematic.list"})
    public void list(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        File dir = this.we.getWorkingDirectoryFile(this.we.getConfiguration().saveDir);
        File[] files = dir.listFiles();
        if (files == null) {
            throw new FilenameResolutionException(dir.getPath(), "\u041f\u0430\u043f\u043a\u0430 \u0441\u043e \u0441\u0445\u0435\u043c\u0430\u043c\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0430 \u0438\u043b\u0438 \u043e\u043d\u0430 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.");
        }
        StringBuilder build = new StringBuilder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u0441\u0445\u0435\u043c\u044b (\u0418\u043c\u0435\u043d\u0430 \u0444\u0430\u0439\u043b\u043e\u0432 (\u0424\u043e\u0440\u043c\u0430\u0442\u044b)): ");
        final int sortType = args.hasFlag('d') ? -1 : (args.hasFlag('n') ? 1 : 0);
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                int result;
                if (!f1.isFile() || !f2.isFile()) {
                    return -1;
                }
                int n = result = sortType == 0 ? f1.getName().compareToIgnoreCase(f2.getName()) : Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                if (sortType == 1) {
                    result = -result;
                }
                return result;
            }
        });
        for (File file : files) {
            if (!file.isFile()) continue;
            build.append("\n\u00a79");
            SchematicFormat format = SchematicFormat.getFormat(file);
            build.append(file.getName()).append(": ").append(format == null ? "Unknown" : format.getName());
        }
        player.print(build.toString());
    }
}

