/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import java.io.File;

public class ScriptingCommands {
    private final WorldEdit we;

    public ScriptingCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"cs"}, usage="<filename> [args...]", desc="\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 CraftScript", min=1, max=-1)
    @CommandPermissions(value={"worldedit.scripting.execute"})
    @Logging(value=Logging.LogMode.ALL)
    public void execute(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String[] scriptArgs = args.getSlice(1);
        String name = args.getString(0);
        if (!player.hasPermission("worldedit.scripting.execute." + name)) {
            player.printError("\u0423 \u0412\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u044d\u0442\u043e\u0433\u043e \u0441\u043a\u0440\u0438\u043f\u0442\u0430.");
            return;
        }
        session.setLastScript(name);
        File dir = this.we.getWorkingDirectoryFile(this.we.getConfiguration().scriptsDir);
        File f = this.we.getSafeOpenFile(player, dir, name, "js", "js");
        this.we.runScript(player, f, scriptArgs);
    }

    @Command(aliases={".s"}, usage="[args...]", desc="\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0438\u0439 CraftScript", min=0, max=-1)
    @CommandPermissions(value={"worldedit.scripting.execute"})
    @Logging(value=Logging.LogMode.ALL)
    public void executeLast(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String lastScript = session.getLastScript();
        if (!player.hasPermission("worldedit.scripting.execute." + lastScript)) {
            player.printError("\u0423 \u0412\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u044d\u0442\u043e\u0433\u043e \u0441\u043a\u0440\u0438\u043f\u0442\u0430.");
            return;
        }
        if (lastScript == null) {
            player.printError("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /cs \u0441 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435\u043c \u0441\u043a\u0440\u0438\u043f\u0442\u0430.");
            return;
        }
        String[] scriptArgs = args.getSlice(0);
        File dir = this.we.getWorkingDirectoryFile(this.we.getConfiguration().scriptsDir);
        File f = this.we.getSafeOpenFile(player, dir, lastScript, "js", "js");
        this.we.runScript(player, f, scriptArgs);
    }
}

