/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandAlias;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.BlockVector2D;
import com.sk89q.worldedit.Countable;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockType;
import com.sk89q.worldedit.commands.InsufficientArgumentsException;
import com.sk89q.worldedit.cui.CUIRegion;
import com.sk89q.worldedit.data.ChunkStore;
import com.sk89q.worldedit.regions.ConvexPolyhedralRegionSelector;
import com.sk89q.worldedit.regions.CuboidRegionSelector;
import com.sk89q.worldedit.regions.CylinderRegionSelector;
import com.sk89q.worldedit.regions.EllipsoidRegionSelector;
import com.sk89q.worldedit.regions.ExtendingCuboidRegionSelector;
import com.sk89q.worldedit.regions.Polygonal2DRegionSelector;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.SphereRegionSelector;
import com.sk89q.worldedit.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SelectionCommands {
    private final WorldEdit we;

    public SelectionCommands(WorldEdit we) {
        this.we = we;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Command(aliases={"/pos1"}, usage="[coordinates]", desc="\u0417\u0430\u0434\u0430\u0435\u0442 \u043f\u0435\u0440\u0432\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e", min=0, max=1)
    @Logging(value=Logging.LogMode.POSITION)
    @CommandPermissions(value={"worldedit.selection.pos"})
    public void pos1(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        void var5_8;
        if (args.argsLength() == 1) {
            if (!args.getString(0).matches("-?\\d+,-?\\d+,-?\\d+")) {
                player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b " + args.getString(0));
                return;
            }
            String[] coords = args.getString(0).split(",");
            Vector vector = new Vector(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        } else {
            WorldVector worldVector = player.getBlockIn();
        }
        if (!session.getRegionSelector(player.getWorld()).selectPrimary((Vector)var5_8)) {
            player.printError("\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0443\u0436\u0435 \u0437\u0430\u0434\u0430\u043d\u0430.");
            return;
        }
        session.getRegionSelector(player.getWorld()).explainPrimarySelection(player, session, (Vector)var5_8);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Command(aliases={"/pos2"}, usage="[coordinates]", desc="\u0417\u0430\u0434\u0430\u0435\u0442 \u0432\u0442\u043e\u0440\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e", min=0, max=1)
    @Logging(value=Logging.LogMode.POSITION)
    @CommandPermissions(value={"worldedit.selection.pos"})
    public void pos2(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        void var5_8;
        if (args.argsLength() == 1) {
            if (!args.getString(0).matches("-?\\d+,-?\\d+,-?\\d+")) {
                player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b " + args.getString(0));
                return;
            }
            String[] coords = args.getString(0).split(",");
            Vector vector = new Vector(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
        } else {
            WorldVector worldVector = player.getBlockIn();
        }
        if (!session.getRegionSelector(player.getWorld()).selectSecondary((Vector)var5_8)) {
            player.printError("\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0443\u0436\u0435 \u0437\u0430\u0434\u0430\u043d\u0430.");
            return;
        }
        session.getRegionSelector(player.getWorld()).explainSecondarySelection(player, session, (Vector)var5_8);
    }

    @Command(aliases={"/hpos1"}, usage="", desc="\u0417\u0430\u0434\u0430\u0435\u0442 \u043f\u0435\u0440\u0432\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e \u043d\u0430 \u0431\u043b\u043e\u043a, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0412\u044b \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435.", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.hpos"})
    public void hpos1(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockTrace(300);
        if (pos != null) {
            if (!session.getRegionSelector(player.getWorld()).selectPrimary(pos)) {
                player.printError("\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0443\u0436\u0435 \u0437\u0430\u0434\u0430\u043d\u0430.");
                return;
            }
            session.getRegionSelector(player.getWorld()).explainPrimarySelection(player, session, pos);
        } else {
            player.printError("\u041d\u0435\u0442 \u0431\u043b\u043e\u043a\u043e\u0432 \u0432 \u043f\u043e\u043b\u0435 \u0437\u0440\u0435\u043d\u0438\u044f!");
        }
    }

    @Command(aliases={"/hpos2"}, usage="", desc="\u0417\u0430\u0434\u0430\u0435\u0442 \u0432\u0442\u043e\u0440\u0443\u044e \u043f\u043e\u0437\u0438\u0446\u0438\u044e \u043d\u0430 \u0431\u043b\u043e\u043a, \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u0412\u044b \u0441\u043c\u043e\u0442\u0440\u0438\u0442\u0435.", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.hpos"})
    public void hpos2(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        WorldVector pos = player.getBlockTrace(300);
        if (pos != null) {
            if (!session.getRegionSelector(player.getWorld()).selectSecondary(pos)) {
                player.printError("\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0443\u0436\u0435 \u0437\u0430\u0434\u0430\u043d\u0430.");
                return;
            }
            session.getRegionSelector(player.getWorld()).explainSecondarySelection(player, session, pos);
        } else {
            player.printError("\u041d\u0435\u0442 \u0431\u043b\u043e\u043a\u043e\u0432 \u0432 \u043f\u043e\u043b\u0435 \u0437\u0440\u0435\u043d\u0438\u044f!");
        }
    }

    @Command(aliases={"/chunk"}, usage="[x,z \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b]", flags="sc", desc="\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0433\u043e \u0447\u0430\u043d\u043a\u0430.", help="Set the selection to the chunk you are currently in.\nWith the -s flag, your current selection is expanded\nto encompass all chunks that are part of it.\n\nSpecifying coordinates will use those instead of your\ncurrent position. Use -c to specify chunk coordinates,\notherwise full coordinates will be implied.\n(for example, the coordinates 5,5 are the same as -c 0,0)", min=0, max=1)
    @Logging(value=Logging.LogMode.POSITION)
    @CommandPermissions(value={"worldedit.selection.chunk"})
    public void chunk(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Vector max;
        Vector min;
        LocalWorld world = player.getWorld();
        if (args.hasFlag('s')) {
            Region region = session.getSelection(world);
            BlockVector2D min2D = ChunkStore.toChunk(region.getMinimumPoint());
            BlockVector2D max2D = ChunkStore.toChunk(region.getMaximumPoint());
            min = new Vector(min2D.getBlockX() * 16, 0, min2D.getBlockZ() * 16);
            max = new Vector(max2D.getBlockX() * 16 + 15, world.getMaxY(), max2D.getBlockZ() * 16 + 15);
            player.print("\u0427\u0430\u043d\u043a \u0432\u044b\u0434\u0435\u043b\u0435\u043d: (" + min2D.getBlockX() + ", " + min2D.getBlockZ() + ") - (" + max2D.getBlockX() + ", " + max2D.getBlockZ() + ")");
        } else {
            Vector2D min2D;
            if (args.argsLength() == 1) {
                String[] coords = args.getString(0).split(",");
                if (coords.length != 2) {
                    throw new InsufficientArgumentsException("Invalid coordinates specified.");
                }
                int x = Integer.parseInt(coords[0]);
                int z = Integer.parseInt(coords[1]);
                Vector2D pos = new Vector2D(x, z);
                min2D = args.hasFlag('c') ? pos : ChunkStore.toChunk(pos.toVector());
            } else {
                min2D = ChunkStore.toChunk(player.getBlockIn());
            }
            min = new Vector(min2D.getBlockX() * 16, 0, min2D.getBlockZ() * 16);
            max = min.add(15, world.getMaxY(), 15);
            player.print("\u0427\u0430\u043d\u043a \u0432\u044b\u0431\u0440\u0430\u043d: " + min2D.getBlockX() + ", " + min2D.getBlockZ());
        }
        CuboidRegionSelector selector = session.getRegionSelector(world) instanceof ExtendingCuboidRegionSelector ? new ExtendingCuboidRegionSelector(world) : new CuboidRegionSelector(world);
        selector.selectPrimary(min);
        selector.selectSecondary(max);
        session.setRegionSelector(world, selector);
        session.dispatchCUISelection(player);
    }

    @Command(aliases={"/wand"}, usage="", desc="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u0434\u043b\u044f \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u0439", min=0, max=0)
    @CommandPermissions(value={"worldedit.wand"})
    public void wand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.giveItem(this.we.getConfiguration().wandItem, 1);
        player.print("\u041b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a: \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0432\u043e\u0439 \u0442\u043e\u0447\u043a\u0438; \u041f\u0440\u0430\u0432\u044b\u0439 \u043a\u043b\u0438\u043a: \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0432\u0442\u043e\u0440\u043e\u0439 \u0442\u043e\u0447\u043a\u0438");
    }

    @Command(aliases={"toggleeditwand"}, usage="", desc="\u041f\u0435\u0440\u0435\u043a\u044e\u0447\u0430\u0435\u0442 \u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u0430 \u0434\u043b\u044f \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u043e\u0437\u0438\u0446\u0438\u0439.", min=0, max=0)
    @CommandPermissions(value={"worldedit.wand.toggle"})
    public void toggleWand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setToolControl(!session.isToolControlEnabled());
        if (session.isToolControlEnabled()) {
            player.print("\u0422\u0435\u043f\u0435\u0440\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442 \u043f\u043e\u0437\u0438\u0446\u0438\u0438.");
        } else {
            player.print("\u0422\u0435\u043f\u0435\u0440\u044c \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 \u0438 \u0443 \u043d\u0435\u0433\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0435 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435.");
        }
    }

    @Command(aliases={"/expand"}, usage="<amount> [reverse-amount] <direction>", desc="\u0420\u0430\u0441\u0448\u0438\u0440\u044f\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e", min=1, max=3)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.expand"})
    public void expand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (args.getString(0).equalsIgnoreCase("vert") || args.getString(0).equalsIgnoreCase("vertical")) {
            Region region = session.getSelection(player.getWorld());
            try {
                int oldSize = region.getArea();
                region.expand(new Vector(0, player.getWorld().getMaxY() + 1, 0), new Vector(0, -(player.getWorld().getMaxY() + 1), 0));
                session.getRegionSelector(player.getWorld()).learnChanges();
                int newSize = region.getArea();
                session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
                player.print("\u0420\u0435\u0433\u0438\u043e\u043d \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d \u043d\u0430 " + (newSize - oldSize) + " " + StringUtil.plural(newSize - oldSize, "\u0431\u043b\u043e\u043a", "\u0431\u043b\u043e\u043a\u0430", "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
            }
            catch (RegionOperationException e) {
                player.printError(e.getMessage());
            }
            return;
        }
        ArrayList<Vector> dirs = new ArrayList<Vector>();
        int change = args.getInteger(0);
        int reverseChange = 0;
        switch (args.argsLength()) {
            case 2: {
                try {
                    reverseChange = args.getInteger(1);
                    dirs.add(this.we.getDirection(player, "me"));
                }
                catch (NumberFormatException e) {
                    if (args.getString(1).contains(",")) {
                        String[] split;
                        for (String s : split = args.getString(1).split(",")) {
                            dirs.add(this.we.getDirection(player, s.toLowerCase()));
                        }
                        break;
                    }
                    dirs.add(this.we.getDirection(player, args.getString(1).toLowerCase()));
                }
            }
            case 3: {
                reverseChange = args.getInteger(1);
                if (args.getString(2).contains(",")) {
                    String[] split;
                    for (String s : split = args.getString(2).split(",")) {
                        dirs.add(this.we.getDirection(player, s.toLowerCase()));
                    }
                    break;
                }
                dirs.add(this.we.getDirection(player, args.getString(2).toLowerCase()));
                break;
            }
            default: {
                dirs.add(this.we.getDirection(player, "me"));
            }
        }
        Region region = session.getSelection(player.getWorld());
        int oldSize = region.getArea();
        if (reverseChange == 0) {
            for (Vector dir : dirs) {
                region.expand(dir.multiply(change));
            }
        } else {
            for (Vector dir : dirs) {
                region.expand(dir.multiply(change), dir.multiply(-reverseChange));
            }
        }
        session.getRegionSelector(player.getWorld()).learnChanges();
        int newSize = region.getArea();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("\u0420\u0435\u0433\u0438\u043e\u043d \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d \u043d\u0430 " + (newSize - oldSize) + " " + StringUtil.plural(newSize - oldSize, "\u0431\u043b\u043e\u043a", "\u0431\u043b\u043e\u043a\u0430", "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/contract"}, usage="<amount> [reverse-amount] [direction]", desc="\u0423\u043c\u0435\u043d\u044c\u0448\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432 \u0437\u0430\u0434\u0430\u043d\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438.", min=1, max=3)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.contract"})
    public void contract(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        ArrayList<Vector> dirs = new ArrayList<Vector>();
        int change = args.getInteger(0);
        int reverseChange = 0;
        switch (args.argsLength()) {
            case 2: {
                try {
                    reverseChange = args.getInteger(1);
                    dirs.add(this.we.getDirection(player, "me"));
                }
                catch (NumberFormatException e) {
                    if (args.getString(1).contains(",")) {
                        String[] split;
                        for (String s : split = args.getString(1).split(",")) {
                            dirs.add(this.we.getDirection(player, s.toLowerCase()));
                        }
                        break;
                    }
                    dirs.add(this.we.getDirection(player, args.getString(1).toLowerCase()));
                }
            }
            case 3: {
                reverseChange = args.getInteger(1);
                if (args.getString(2).contains(",")) {
                    String[] split;
                    for (String s : split = args.getString(2).split(",")) {
                        dirs.add(this.we.getDirection(player, s.toLowerCase()));
                    }
                    break;
                }
                dirs.add(this.we.getDirection(player, args.getString(2).toLowerCase()));
                break;
            }
            default: {
                dirs.add(this.we.getDirection(player, "me"));
            }
        }
        try {
            Region region = session.getSelection(player.getWorld());
            int oldSize = region.getArea();
            if (reverseChange == 0) {
                for (Vector dir : dirs) {
                    region.contract(dir.multiply(change));
                }
            } else {
                for (Vector dir : dirs) {
                    region.contract(dir.multiply(change), dir.multiply(-reverseChange));
                }
            }
            session.getRegionSelector(player.getWorld()).learnChanges();
            int newSize = region.getArea();
            session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            player.print("\u0420\u0435\u0433\u0438\u043e\u043d \u0443\u043c\u0435\u043d\u044c\u0448\u0435\u043d \u043d\u0430 " + (oldSize - newSize) + " " + StringUtil.plural(newSize - oldSize, "\u0431\u043b\u043e\u043a", "\u0431\u043b\u043e\u043a\u0430", "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
        }
        catch (RegionOperationException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/shift"}, usage="<amount> [direction]", desc="\u0421\u0434\u0432\u0438\u0433\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0432 \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u043c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0438.", min=1, max=2)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.shift"})
    public void shift(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        ArrayList<Vector> dirs = new ArrayList<Vector>();
        int change = args.getInteger(0);
        if (args.argsLength() == 2) {
            if (args.getString(1).contains(",")) {
                for (String s : args.getString(1).split(",")) {
                    dirs.add(this.we.getDirection(player, s.toLowerCase()));
                }
            } else {
                dirs.add(this.we.getDirection(player, args.getString(1).toLowerCase()));
            }
        } else {
            dirs.add(this.we.getDirection(player, "me"));
        }
        try {
            Region region = session.getSelection(player.getWorld());
            for (Vector dir : dirs) {
                region.shift(dir.multiply(change));
            }
            session.getRegionSelector(player.getWorld()).learnChanges();
            session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
            player.print("\u0420\u0435\u0433\u0438\u043e\u043d \u0441\u0434\u0432\u0438\u043d\u0443\u0442.");
        }
        catch (RegionOperationException e) {
            player.printError(e.getMessage());
        }
    }

    @Command(aliases={"/outset"}, usage="<amount>", desc="\u0420\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0440\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u0432\u043e \u0432\u0441\u0435\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u0445.", help="\u0420\u0430\u0441\u0448\u0438\u0440\u044f\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u043e\u0431\u043b\u0430\u0441\u0442\u044c \u0432\u043e \u0432\u0441\u0435\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u0445.\n\u0424\u043b\u0430\u0433\u0438:\n  -h \u0442\u043e\u043b\u044c\u043a\u043e \u0433\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u043e\n  -v \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u043e\n", flags="hv", min=1, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.outset"})
    public void outset(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        region.expand(this.getChangesForEachDir(args));
        session.getRegionSelector(player.getWorld()).learnChanges();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("\u0420\u0435\u0433\u0438\u043e\u043d \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d.");
    }

    @Command(aliases={"/inset"}, usage="<amount>", desc="\u0421\u0443\u0437\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e.", help="\u0421\u0443\u0436\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0432\u043e \u0432\u0441\u0435\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u0445.\n\u0424\u043b\u0430\u0433\u0438:\n  -h \u0442\u043e\u044c\u043a\u043e \u0433\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u043e\n  -v \u0442\u043e\u043b\u044c\u043a\u043e \u0432\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u043e\n", flags="hv", min=1, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.selection.inset"})
    public void inset(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Region region = session.getSelection(player.getWorld());
        region.contract(this.getChangesForEachDir(args));
        session.getRegionSelector(player.getWorld()).learnChanges();
        session.getRegionSelector(player.getWorld()).explainRegionAdjust(player, session);
        player.print("\u0420\u0435\u0433\u0438\u043e\u043d \u0441\u0443\u0436\u0435\u043d.");
    }

    private Vector[] getChangesForEachDir(CommandContext args) {
        ArrayList<Vector> changes = new ArrayList<Vector>(6);
        int change = args.getInteger(0);
        if (!args.hasFlag('h')) {
            changes.add(new Vector(0, 1, 0).multiply(change));
            changes.add(new Vector(0, -1, 0).multiply(change));
        }
        if (!args.hasFlag('v')) {
            changes.add(new Vector(1, 0, 0).multiply(change));
            changes.add(new Vector(-1, 0, 0).multiply(change));
            changes.add(new Vector(0, 0, 1).multiply(change));
            changes.add(new Vector(0, 0, -1).multiply(change));
        }
        return changes.toArray(new Vector[0]);
    }

    @Command(aliases={"/size"}, flags="c", usage="", desc="\u041f\u043e\u043b\u0443\u0447\u0430\u0435\u0442 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438", min=0, max=0)
    @CommandPermissions(value={"worldedit.selection.size"})
    public void size(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (args.hasFlag('c')) {
            CuboidClipboard clipboard = session.getClipboard();
            Vector size = clipboard.getSize();
            Vector offset = clipboard.getOffset();
            player.print("\u0420\u0430\u0437\u043c\u0435\u0440: " + size);
            player.print("\u0421\u043c\u0435\u0449\u0435\u043d\u0438\u0435: " + offset);
            player.print("\u0414\u0438\u0430\u0433\u043e\u043d\u0430\u043b\u044c: " + size.distance(Vector.ONE));
            player.print("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u043b\u043e\u043a\u043e\u0432: " + (int)(size.getX() * size.getY() * size.getZ()));
            return;
        }
        Region region = session.getSelection(player.getWorld());
        Vector size = region.getMaximumPoint().subtract(region.getMinimumPoint()).add(1, 1, 1);
        player.print("\u0422\u0438\u043f: " + session.getRegionSelector(player.getWorld()).getTypeName());
        for (String line : session.getRegionSelector(player.getWorld()).getInformationLines()) {
            player.print(line);
        }
        player.print("\u0420\u0430\u0437\u043c\u0435\u0440: " + size);
        player.print("\u0414\u0438\u0430\u0433\u043e\u043d\u0430\u043b\u044c \u043a\u0443\u0431\u043e\u0438\u0434\u0430: " + region.getMaximumPoint().distance(region.getMinimumPoint()));
        player.print("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u043b\u043e\u043a\u043e\u0432: " + region.getArea());
    }

    @Command(aliases={"/count"}, usage="<block>", desc="\u041f\u043e\u0434\u0441\u0447\u0435\u0442 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u0431\u043b\u043e\u043a\u0430", flags="d", min=1, max=1)
    @CommandPermissions(value={"worldedit.analysis.count"})
    public void count(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        boolean useData = args.hasFlag('d');
        if (args.getString(0).contains(":")) {
            useData = true;
        }
        if (useData) {
            Set<BaseBlock> searchBlocks = this.we.getBlocks(player, args.getString(0), true);
            int count = editSession.countBlocks(session.getSelection(player.getWorld()), searchBlocks);
            player.print("\u0412 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 " + count + StringUtil.plural(count, " \u0431\u043b\u043e\u043a", " \u0431\u043b\u043e\u043a\u0430", " \u0431\u043b\u043e\u043a\u043e\u0432") + " \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430.");
        } else {
            Set<Integer> searchIDs = this.we.getBlockIDs(player, args.getString(0), true);
            int count = editSession.countBlock(session.getSelection(player.getWorld()), searchIDs);
            player.print("\u0412 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 " + count + StringUtil.plural(count, " \u0431\u043b\u043e\u043a", " \u0431\u043b\u043e\u043a\u0430", " \u0431\u043b\u043e\u043a\u043e\u0432") + " \u0437\u0430\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430.");
        }
    }

    @Command(aliases={"/distr"}, usage="", desc="\u041f\u043e\u0434\u0441\u0447\u0435\u0442 \u043a\u043e\u043b\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0431\u043b\u043e\u043a\u043e\u0432 \u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.", help="\u0421\u0447\u0438\u0442\u0430\u0435\u0442 \u043a\u043e\u043b\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0431\u043b\u043e\u043a\u043e\u0432 \u0432 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438.\n\u0424\u043b\u0430\u0433 -c \u0441\u0447\u0438\u0442\u0435\u0442 \u0431\u043b\u043e\u043a\u0438 \u0432 \u0431\u0443\u0444\u0435\u0440\u0435 \u043e\u0431\u043c\u0435\u043d\u0430.\n\u0424\u043b\u0430\u0433 -d \u0440\u0430\u0437\u0431\u0438\u0432\u0430\u0435\u0442 \u0431\u043b\u043e\u043a\u0438 \u043f\u043e \u0434\u0430\u043d\u043d\u044b\u043c", flags="cd", min=0, max=0)
    @CommandPermissions(value={"worldedit.analysis.distr"})
    public void distr(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int size;
        boolean useData = args.hasFlag('d');
        List<Countable<Integer>> distribution = null;
        List<Countable<BaseBlock>> distributionData = null;
        if (args.hasFlag('c')) {
            CuboidClipboard clip = session.getClipboard();
            if (useData) {
                distributionData = clip.getBlockDistributionWithData();
            } else {
                distribution = clip.getBlockDistribution();
            }
            size = clip.getHeight() * clip.getLength() * clip.getWidth();
        } else {
            if (useData) {
                distributionData = editSession.getBlockDistributionWithData(session.getSelection(player.getWorld()));
            } else {
                distribution = editSession.getBlockDistribution(session.getSelection(player.getWorld()));
            }
            size = session.getSelection(player.getWorld()).getArea();
        }
        if (useData && distributionData.size() <= 0 || !useData && distribution.size() <= 0) {
            player.printError("\u0412 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 \u0431\u043b\u043e\u043a\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b.");
            return;
        }
        player.print("\u0412 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0438 " + size + StringUtil.plural(size, " \u0431\u043b\u043e\u043a", " \u0431\u043b\u043e\u043a\u0430", " \u0431\u043b\u043e\u043a\u043e\u0432"));
        if (useData) {
            for (Countable<Object> countable : distributionData) {
                String name = BlockType.fromID(((BaseBlock)countable.getID()).getId()).getName();
                String str = String.format("%-7s (%.3f%%) %s #%d:%d", String.valueOf(countable.getAmount()), (double)countable.getAmount() / (double)size * 100.0, name == null ? "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e" : name, ((BaseBlock)countable.getID()).getType(), ((BaseBlock)countable.getID()).getData());
                player.print(str);
            }
        } else {
            for (Countable<Object> countable : distribution) {
                BlockType block = BlockType.fromID((Integer)countable.getID());
                String str = String.format("%-7s (%.3f%%) %s #%d", String.valueOf(countable.getAmount()), (double)countable.getAmount() / (double)size * 100.0, block == null ? "\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e" : block.getName(), countable.getID());
                player.print(str);
            }
        }
    }

    @Command(aliases={"/sel", ";"}, usage="[cuboid|extend|poly|ellipsoid|sphere|cyl|convex]", desc="\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u0442\u0438\u043f \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0440\u0435\u0433\u0438\u043e\u043d\u0430", min=0, max=1)
    public void select(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        CUIRegion selector;
        LocalWorld world = player.getWorld();
        if (args.argsLength() == 0) {
            session.getRegionSelector(world).clear();
            session.dispatchCUISelection(player);
            player.print("\u0412\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u043e\u0447\u0438\u0449\u0435\u043d\u043e.");
            return;
        }
        String typeName = args.getString(0);
        RegionSelector oldSelector = session.getRegionSelector(world);
        if (typeName.equalsIgnoreCase("cuboid")) {
            selector = new CuboidRegionSelector(oldSelector);
            player.print("\u041a\u0443\u0431\u043e\u0438\u0434: \u043b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u043f\u0435\u0440\u0432\u043e\u0439 \u043f\u043e\u0437\u0438\u0446\u0438\u0438,\u043f\u0440\u0430\u0432\u044b\u0439 \u0434\u043b\u044f \u0432\u0442\u043e\u0440\u043e\u0439");
        } else if (typeName.equalsIgnoreCase("extend")) {
            selector = new ExtendingCuboidRegionSelector(oldSelector);
            player.print("\u041a\u0443\u0431\u043e\u0438\u0434: \u043b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0441\u0442\u0430\u0440\u0442\u043e\u0432\u043e\u0439 \u0442\u043e\u0447\u043a\u0438,\u043f\u0440\u0430\u0432\u044b\u0439 \u0434\u043b\u044f \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0439");
        } else if (typeName.equalsIgnoreCase("poly")) {
            int maxPoints = this.we.getMaximumPolygonalPoints(player);
            selector = new Polygonal2DRegionSelector(oldSelector, maxPoints);
            player.print("2D \u041f\u043e\u043b\u0438\u0433\u043e\u043d: \u043b\u0435\u0432\u044b\u0439/\u043f\u0440\u0430\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0442\u043e\u0447\u043a\u0438.");
            if (maxPoints > -1) {
                player.print(maxPoints + " \u0442\u043e\u0447\u0435\u043a(\u0430) \u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c.");
            }
        } else if (typeName.equalsIgnoreCase("ellipsoid")) {
            selector = new EllipsoidRegionSelector(oldSelector);
            player.print("\u042d\u043b\u043b\u0438\u043f\u0441\u043e\u0438\u0434: \u043b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a=\u0446\u0435\u043d\u0442\u0440, \u043f\u0440\u0430\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f");
        } else if (typeName.equalsIgnoreCase("sphere")) {
            selector = new SphereRegionSelector(oldSelector);
            player.print("\u0421\u0444\u0435\u0440\u0430: \u043b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a=\u0446\u0435\u043d\u0442\u0440, \u043f\u0440\u0430\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f");
        } else if (typeName.equalsIgnoreCase("cyl")) {
            selector = new CylinderRegionSelector(oldSelector);
            player.print("\u0426\u0438\u043b\u043b\u0438\u043d\u0434\u0440: \u043b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a=\u0446\u0435\u043d\u0442\u0440, \u043f\u0440\u0430\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0434\u043b\u044f \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u044f.");
        } else if (typeName.equalsIgnoreCase("convex") || typeName.equalsIgnoreCase("hull") || typeName.equalsIgnoreCase("polyhedron")) {
            int maxVertices = this.we.getMaximumPolyhedronPoints(player);
            selector = new ConvexPolyhedralRegionSelector(oldSelector, maxVertices);
            player.print("\u0412\u044b\u043f\u0443\u043a\u043b\u044b\u0439 \u043f\u043e\u043b\u0438\u0433\u043e\u043d: \u041b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a=\u041f\u0435\u0440\u0432\u0430\u044f \u0432\u0435\u0440\u0448\u0438\u043d\u0430, \u043f\u0440\u0430\u0432\u044b\u0439 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f.");
        } else {
            player.printError("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0439 \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0430\u043a\u0438\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435: cuboid(\u043a\u0443\u0431\u043e\u0438\u0434)|extend(\u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u0438\u0435)|poly(\u043f\u043e\u043b\u0438\u0433\u043e\u043d)|ellipsoid(\u044d\u043b\u043b\u0438\u043f\u0441\u043e\u0438\u0434)|sphere(\u0441\u0444\u0435\u0440\u0430)|cyl(\u0446\u0438\u043b\u0438\u043d\u0434\u0440)|convex(\u0432\u044b\u043f\u0443\u043a\u043b\u044b\u0439 \u043f\u043e\u043b\u0438\u0433\u043e\u043d).");
            return;
        }
        session.setRegionSelector(world, (RegionSelector)((Object)selector));
        session.dispatchCUISelection(player);
    }

    @Command(aliases={"/desel", "/deselect"}, desc="\u0421\u0431\u0440\u0430\u0441\u044b\u0432\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u0435")
    @CommandAlias(value={"/sel"})
    public void deselect() {
    }
}

