/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.data.MissingWorldException;
import com.sk89q.worldedit.snapshots.InvalidSnapshotException;
import com.sk89q.worldedit.snapshots.Snapshot;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;

public class SnapshotCommands {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final WorldEdit we;

    public SnapshotCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"list"}, usage="[num]", desc="\u0421\u043f\u0438\u0441\u043e\u043a \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439", min=0, max=1)
    @CommandPermissions(value={"worldedit.snapshots.list"})
    public void list(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430.");
            return;
        }
        try {
            List<Snapshot> snapshots = config.snapshotRepo.getSnapshots(true, player.getWorld().getName());
            if (snapshots.size() > 0) {
                int num = args.argsLength() > 0 ? Math.min(40, Math.max(5, args.getInteger(0))) : 5;
                player.print("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0435 \u043a\u043e\u043f\u0438\u0438 \u0434\u043b\u044f \u043c\u0438\u0440\u0430: '" + player.getWorld().getName() + "'");
                for (int i = 0; i < Math.min(num, snapshots.size()); i = (int)((byte)(i + 1))) {
                    player.print(i + 1 + ". " + snapshots.get(i).getName());
                }
                player.print("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /snap use [snapshot] \u0438\u043b\u0438 /snap.");
            } else {
                player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. \u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u0434\u043b\u044f \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u044b\u0445 \u0434\u0435\u0442\u0430\u043b\u0435\u0439.");
                File dir = config.snapshotRepo.getDirectory();
                try {
                    logger.info("WorldEdit \u043d\u0435 \u043d\u0430\u0448\u0435\u043b \u0440\u0430\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439: \u043f\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u043b \u0432: " + dir.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.info("WorldEdit found no snapshots: looked in (NON-RESOLVABLE PATH - does it exist?): " + dir.getPath());
                }
            }
        }
        catch (MissingWorldException ex) {
            player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u043c\u0438\u0440\u0430 \u043d\u0435\u0442.");
        }
    }

    @Command(aliases={"use"}, usage="<snapshot>", desc="\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f", min=1, max=1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void use(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        block8: {
            LocalConfiguration config = this.we.getConfiguration();
            if (config.snapshotRepo == null) {
                player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430.");
                return;
            }
            String name = args.getString(0);
            if (name.equalsIgnoreCase("latest")) {
                try {
                    Snapshot snapshot = config.snapshotRepo.getDefaultSnapshot(player.getWorld().getName());
                    if (snapshot != null) {
                        session.setSnapshot(null);
                        player.print("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043d\u043e\u0432\u0435\u0439\u0448\u0430\u044f \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f.");
                        break block8;
                    }
                    player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
                }
                catch (MissingWorldException ex) {
                    player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u0432 \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0435 \u043d\u0435\u0442.");
                }
            } else {
                try {
                    session.setSnapshot(config.snapshotRepo.getSnapshot(name));
                    player.print("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u043f\u043e\u0434 \u0438\u043c\u0435\u043d\u0435\u043c: " + name);
                }
                catch (InvalidSnapshotException e) {
                    player.printError("\u042d\u0442\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430.");
                }
            }
        }
    }

    @Command(aliases={"sel"}, usage="<index>", desc="\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0435 \u0441\u043f\u0438\u0441\u043a\u0430", min=1, max=1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void sel(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430.");
            return;
        }
        int index = -1;
        try {
            index = Integer.parseInt(args.getString(0));
        }
        catch (NumberFormatException e) {
            player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441, " + args.getString(0) + " \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0446\u0435\u043b\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c.");
            return;
        }
        if (index < 1) {
            player.printError("\u0418\u043d\u0434\u0435\u043a\u0441 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0440\u0430\u0432\u0435\u043d \u0438\u043b\u0438 \u0432\u044b\u0448\u0435 \u043e\u0434\u043d\u043e\u0433\u043e.");
            return;
        }
        try {
            List<Snapshot> snapshots = config.snapshotRepo.getSnapshots(true, player.getWorld().getName());
            if (snapshots.size() < index) {
                player.printError("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441, \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u043c\u0435\u0436\u0434\u0443 1 \u0438 " + snapshots.size() + ".");
                return;
            }
            Snapshot snapshot = snapshots.get(index - 1);
            if (snapshot == null) {
                player.printError("\u042d\u0442\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0438\u043b\u0438 \u043f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u0430.");
                return;
            }
            session.setSnapshot(snapshot);
            player.print("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u043f\u043e\u0434 \u0438\u043c\u0435\u043d\u0435\u043c: " + snapshot.getName());
        }
        catch (MissingWorldException e) {
            player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u0434\u043b\u044f \u044d\u0442\u043e\u0433\u043e \u043c\u0438\u0440\u0430 \u043d\u0435\u0442.");
        }
    }

    @Command(aliases={"before"}, usage="<date>", desc="\u0412\u044b\u0431\u0435\u0440\u0430\u0435\u0442 \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0443\u044e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u0434\u043e \u0434\u0430\u0442\u044b", min=1, max=-1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void before(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430.");
            return;
        }
        Calendar date = session.detectDate(args.getJoinedStrings(0));
        if (date == null) {
            player.printError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443.");
        } else {
            try {
                Snapshot snapshot = config.snapshotRepo.getSnapshotBefore(date, player.getWorld().getName());
                if (snapshot == null) {
                    dateFormat.setTimeZone(session.getTimeZone());
                    player.printError("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u0434\u043e " + dateFormat.format(date.getTime()) + ".");
                } else {
                    session.setSnapshot(snapshot);
                    player.print("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u043f\u043e\u0434 \u0438\u043c\u0435\u043d\u0435\u043c: " + snapshot.getName());
                }
            }
            catch (MissingWorldException ex) {
                player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u0432 \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0435 \u043d\u0435\u0442.");
            }
        }
    }

    @Command(aliases={"after"}, usage="<date>", desc="\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0443\u044e \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u043f\u043e\u0441\u043b\u0435 \u0434\u0430\u0442\u044b.", min=1, max=-1)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void after(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        if (config.snapshotRepo == null) {
            player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430.");
            return;
        }
        Calendar date = session.detectDate(args.getJoinedStrings(0));
        if (date == null) {
            player.printError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0432\u0432\u0435\u0434\u0435\u043d\u043d\u0443\u044e \u0434\u0430\u0442\u0443.");
        } else {
            try {
                Snapshot snapshot = config.snapshotRepo.getSnapshotAfter(date, player.getWorld().getName());
                if (snapshot == null) {
                    dateFormat.setTimeZone(session.getTimeZone());
                    player.printError("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0430\u0439\u0442\u0438 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e \u043f\u043e\u0441\u043b\u0435 " + dateFormat.format(date.getTime()) + ".");
                } else {
                    session.setSnapshot(snapshot);
                    player.print("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u043f\u043e\u0434 \u0438\u043c\u0435\u043d\u0435\u043c: " + snapshot.getName());
                }
            }
            catch (MissingWorldException ex) {
                player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u0432 \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0435 \u043d\u0435\u0442.");
            }
        }
    }
}

