/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.commands.SnapshotCommands;
import com.sk89q.worldedit.data.ChunkStore;
import com.sk89q.worldedit.data.DataException;
import com.sk89q.worldedit.data.MissingWorldException;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.snapshots.InvalidSnapshotException;
import com.sk89q.worldedit.snapshots.Snapshot;
import com.sk89q.worldedit.snapshots.SnapshotRestore;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;

public class SnapshotUtilCommands {
    private static final Logger logger = Logger.getLogger("Minecraft.WorldEdit");
    private final WorldEdit we;

    public SnapshotUtilCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"snapshot", "snap"}, desc="\u041a\u043e\u043c\u0430\u043d\u0434\u044b \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439")
    @NestedCommand(value={SnapshotCommands.class})
    public void snapshot(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(aliases={"restore", "/restore"}, usage="[snapshot]", desc="\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u0443\u044e \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044e \u0438\u0437 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438", min=0, max=1)
    @Logging(value=Logging.LogMode.REGION)
    @CommandPermissions(value={"worldedit.snapshots.restore"})
    public void restore(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Snapshot snapshot;
        Region region;
        block24: {
            LocalConfiguration config = this.we.getConfiguration();
            if (config.snapshotRepo == null) {
                player.printError("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e.");
                return;
            }
            region = session.getSelection(player.getWorld());
            if (args.argsLength() > 0) {
                try {
                    snapshot = config.snapshotRepo.getSnapshot(args.getString(0));
                }
                catch (InvalidSnapshotException e) {
                    player.printError("\u042d\u0442\u0430 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0438\u043b\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
                    return;
                }
            } else {
                snapshot = session.getSnapshot();
            }
            if (snapshot == null) {
                try {
                    snapshot = config.snapshotRepo.getDefaultSnapshot(player.getWorld().getName());
                    if (snapshot != null) break block24;
                    player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e. \u0421\u043c\u043e\u0442\u0440\u0438\u0442\u0435 \u043a\u043e\u043d\u0441\u043e\u043b\u044c \u0434\u043b\u044f \u043f\u043e\u0434\u0440\u043e\u0431\u043d\u044b\u0439 \u0434\u0435\u0442\u0430\u043b\u0435\u0439.");
                    File dir = config.snapshotRepo.getDirectory();
                    try {
                        logger.info("WorldEdit \u043d\u0435 \u043d\u0430\u0448\u0435\u043b \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439: \u0441\u043c\u043e\u0442\u0440\u0435\u043b \u0432: " + dir.getCanonicalPath());
                    }
                    catch (IOException e) {
                        logger.info("WorldEdit found no snapshots: looked in (NON-RESOLVABLE PATH - does it exist?): " + dir.getPath());
                    }
                    return;
                }
                catch (MissingWorldException ex) {
                    player.printError("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u044b\u0445 \u043a\u043e\u043f\u0438\u0439 \u0432 \u044d\u0442\u043e\u043c \u043c\u0438\u0440\u0435 \u043d\u0435\u0442.");
                    return;
                }
            }
        }
        ChunkStore chunkStore = null;
        try {
            chunkStore = snapshot.getChunkStore();
            player.print("\u0420\u0435\u0437\u0435\u0440\u0432\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f '" + snapshot.getName() + "' \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430, \u0438\u0434\u0435\u0442 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435..");
        }
        catch (DataException e) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438: " + e.getMessage());
            return;
        }
        catch (IOException e) {
            player.printError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438: " + e.getMessage());
            return;
        }
        try {
            SnapshotRestore restore = new SnapshotRestore(chunkStore, editSession, region);
            restore.restore();
            if (restore.hadTotalFailure()) {
                String error = restore.getLastErrorMessage();
                if (error != null) {
                    player.printError("\u041e\u0448\u0438\u0431\u043a\u0438 \u043f\u0440\u0435\u0434\u043e\u0442\u0432\u0440\u0430\u0442\u044f\u0442 \u043b\u044e\u0431\u044b\u0435 \u0431\u043b\u043e\u043a\u0438 \u0438\u0437 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u043a\u043e\u043f\u0438\u0438.");
                    player.printError("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430: " + error);
                } else {
                    player.printError("\u0427\u0430\u043d\u043a\u0438 \u043d\u0435\u0431\u044b\u0438 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b. (\u041f\u043b\u043e\u0445\u043e\u0439 \u0430\u0440\u0445\u0438\u0432?)");
                }
            } else {
                player.print(String.format("\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e; %d \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u043d\u044b\u0445 \u0447\u0430\u043d\u043a\u043e\u0432(\u0430) \u0438 %d \u0434\u0440\u0443\u0433\u0438\u0445 \u043e\u0448\u0438\u0431\u043e\u043a.", restore.getMissingChunks().size(), restore.getErrorChunks().size()));
            }
        }
        finally {
            try {
                chunkStore.close();
            }
            catch (IOException e) {}
        }
    }
}

