/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.tools.AreaPickaxe;
import com.sk89q.worldedit.tools.RecursivePickaxe;
import com.sk89q.worldedit.tools.SinglePickaxe;

public class SuperPickaxeCommands {
    private final WorldEdit we;

    public SuperPickaxeCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"single"}, usage="", desc="\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0441\u0443\u043f\u0435\u0440\u043a\u0438\u0440\u043a\u0443", min=0, max=0)
    @CommandPermissions(value={"worldedit.superpickaxe"})
    public void single(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setSuperPickaxe(new SinglePickaxe());
        session.enableSuperPickAxe();
        player.print("\u0421\u0443\u043f\u0435\u0440\u043a\u0438\u0440\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430. \u041b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u043a\u0438\u0440\u043a\u043e\u0439 \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0431\u043b\u043e\u043a\u0430. // \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f.");
    }

    @Command(aliases={"area"}, usage="<radius>", desc="\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0441\u0443\u043f\u0435\u0440\u043a\u0438\u0440\u043a\u0443 \u0432 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u043c \u0440\u0430\u0434\u0438\u0443\u0441\u0435.", min=1, max=1)
    @CommandPermissions(value={"worldedit.superpickaxe.area"})
    public void area(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int range = args.getInteger(0);
        if (range > config.maxSuperPickaxeSize) {
            player.printError("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: " + config.maxSuperPickaxeSize);
            return;
        }
        session.setSuperPickaxe(new AreaPickaxe(range));
        session.enableSuperPickAxe();
        player.print("\u0421\u0443\u043f\u0435\u0440\u043a\u0438\u0440\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430. \u041b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u043a\u0438\u0440\u043a\u043e\u0439 \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0431\u043b\u043e\u043a\u0430. // \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f.");
    }

    @Command(aliases={"recur", "recursive"}, usage="<radius>", desc="\u0412\u043a\u043b\u044e\u0447\u0430\u0435\u0442 \u0440\u0435\u043a\u0443\u0440\u0441\u0438\u0432\u043d\u0443\u044e \u0441\u0443\u043f\u0435\u0440\u043a\u0438\u0440\u043a\u0443.", min=1, max=1)
    @CommandPermissions(value={"worldedit.superpickaxe.recursive"})
    public void recursive(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        double range = args.getDouble(0);
        if (range > (double)config.maxSuperPickaxeSize) {
            player.printError("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: " + config.maxSuperPickaxeSize);
            return;
        }
        session.setSuperPickaxe(new RecursivePickaxe(range));
        session.enableSuperPickAxe();
        player.print("\u0421\u0443\u043f\u0435\u0440\u043a\u0438\u0440\u043a\u0430 \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430. \u041b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u043a\u0438\u0440\u043a\u043e\u0439 \u0434\u043b\u044f \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0431\u043b\u043e\u043a\u0430. // \u0434\u043b\u044f \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f.");
    }
}

