/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldedit.commands.BrushCommands;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.tools.BlockDataCyler;
import com.sk89q.worldedit.tools.BlockReplacer;
import com.sk89q.worldedit.tools.DistanceWand;
import com.sk89q.worldedit.tools.FloatingTreeRemover;
import com.sk89q.worldedit.tools.FloodFillTool;
import com.sk89q.worldedit.tools.LongRangeBuildTool;
import com.sk89q.worldedit.tools.QueryTool;
import com.sk89q.worldedit.tools.TreePlanter;
import com.sk89q.worldedit.util.TreeGenerator;

public class ToolCommands {
    private final WorldEdit we;

    public ToolCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"none"}, usage="", desc="\u041e\u0442\u0432\u044f\u0437\u044b\u0432\u0430\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0439 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u043e\u0442 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043e\u0433\u043e \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f.", min=0, max=0)
    public void none(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setTool(player.getItemInHand(), null);
        player.print("\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u043e\u0442\u0432\u044f\u0437\u0430\u043d.");
    }

    @Command(aliases={"info"}, usage="", desc="\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0431\u043b\u043e\u043a\u0435", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.info"})
    public void info(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setTool(player.getItemInHand(), new QueryTool());
        player.print("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0435 \u0441\u0432\u044f\u0437\u0430\u043d\u0430 \u0441 " + ItemType.toHeldName(player.getItemInHand()) + ".");
    }

    @Command(aliases={"tree"}, usage="[type]", desc="\u0413\u0435\u043d\u0435\u0440\u0430\u0442\u043e\u0440 \u0434\u0435\u0440\u0435\u044c\u0435\u0432", min=0, max=1)
    @CommandPermissions(value={"worldedit.tool.tree"})
    public void tree(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        TreeGenerator.TreeType type;
        TreeGenerator.TreeType treeType = type = args.argsLength() > 0 ? (type = TreeGenerator.lookup(args.getString(0))) : TreeGenerator.TreeType.TREE;
        if (type == null) {
            player.printError("\u0422\u0438\u043f \u0434\u0435\u0440\u0435\u0432\u0430 '" + args.getString(0) + "' \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d.");
            return;
        }
        session.setTool(player.getItemInHand(), new TreePlanter(new TreeGenerator(type)));
        player.print("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u0435\u0440\u0435\u0432\u044c\u0435\u0432 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 " + ItemType.toHeldName(player.getItemInHand()) + ".");
    }

    @Command(aliases={"repl"}, usage="<block>", desc="\u0417\u0430\u043c\u0435\u043d\u0438\u0442\u0435\u043b\u044c \u0431\u043b\u043e\u043a\u043e\u0432", min=1, max=1)
    @CommandPermissions(value={"worldedit.tool.replacer"})
    public void repl(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        BaseBlock targetBlock = this.we.getBlock(player, args.getString(0));
        session.setTool(player.getItemInHand(), new BlockReplacer(targetBlock));
        player.print("\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0437\u0430\u043c\u0435\u043d\u044b \u0431\u043b\u043e\u043a\u043e\u0432 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 " + ItemType.toHeldName(player.getItemInHand()) + ".");
    }

    @Command(aliases={"cycler"}, usage="", desc="\u0413\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u0442 \u0446\u0438\u043b\u0438\u043d\u0434\u0440\u044b", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.data-cycler"})
    public void cycler(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setTool(player.getItemInHand(), new BlockDataCyler());
        player.print("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0446\u0438\u043b\u0438\u043d\u0434\u0440\u043e\u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0435\u043d\u0430 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 " + ItemType.toHeldName(player.getItemInHand()) + ".");
    }

    @Command(aliases={"floodfill", "flood"}, usage="<pattern> <range>", desc="\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c \u043f\u043e\u043b\u0430", min=2, max=2)
    @CommandPermissions(value={"worldedit.tool.flood-fill"})
    public void floodFill(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int range = args.getInteger(1);
        if (range > config.maxSuperPickaxeSize) {
            player.printError("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0430\u0437\u043c\u0435\u0440: " + config.maxSuperPickaxeSize);
            return;
        }
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        session.setTool(player.getItemInHand(), new FloodFillTool(range, pattern));
        player.print("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u043b\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 " + ItemType.toHeldName(player.getItemInHand()) + ".");
    }

    @Command(aliases={"brush", "br"}, desc="\u041a\u0438\u0441\u0442\u044c")
    @NestedCommand(value={BrushCommands.class})
    public void brush(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }

    @Command(aliases={"deltree"}, usage="", desc="\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0434\u0435\u0440\u0435\u0432\u044c\u0435\u0432", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.deltree"})
    public void deltree(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setTool(player.getItemInHand(), new FloatingTreeRemover());
        player.print("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0437\u0430\u0434\u0430\u043d\u0430 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 " + ItemType.toHeldName(player.getItemInHand()) + ".");
    }

    @Command(aliases={"farwand"}, usage="", desc="\u0418\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0438", min=0, max=0)
    @CommandPermissions(value={"worldedit.tool.farwand"})
    public void farwand(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setTool(player.getItemInHand(), new DistanceWand());
        player.print("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0438 \u0437\u0430\u0434\u0430\u043d\u0430 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 " + ItemType.toHeldName(player.getItemInHand()) + ".");
    }

    @Command(aliases={"lrbuild", "/lrbuild"}, usage="<leftclick block> <rightclick block>", desc="\u0421\u0442\u0440\u043e\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0438\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442", min=2, max=2)
    @CommandPermissions(value={"worldedit.tool.lrbuild"})
    public void longrangebuildtool(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        BaseBlock secondary = this.we.getBlock(player, args.getString(0));
        BaseBlock primary = this.we.getBlock(player, args.getString(1));
        session.setTool(player.getItemInHand(), new LongRangeBuildTool(primary, secondary));
        player.print("\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0437\u0430\u0434\u0430\u043d\u0430 \u043d\u0430 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 " + ItemType.toHeldName(player.getItemInHand()) + ".");
        player.print("\u041b\u0435\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0437\u0430\u0434\u0430\u043d \u043d\u0430 " + ItemType.toName(secondary.getType()) + "; \u041f\u0440\u0430\u0432\u044b\u0439 \u043a\u043b\u0438\u043a \u0437\u0430\u0434\u0430\u043d \u043d\u0430 " + ItemType.toName(primary.getType()) + ".");
    }
}

