/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.NestedCommand;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.commands.SuperPickaxeCommands;
import com.sk89q.worldedit.commands.ToolCommands;
import com.sk89q.worldedit.masks.Mask;
import com.sk89q.worldedit.patterns.Pattern;

public class ToolUtilCommands {
    private final WorldEdit we;

    public ToolUtilCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/", ","}, usage="[on|off]", desc="\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u0442 \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0441\u0443\u043f\u0435\u0440-\u043a\u0438\u0440\u043a\u0438", min=0, max=1)
    @CommandPermissions(value={"worldedit.superpickaxe"})
    public void togglePickaxe(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String newState = args.getString(0, null);
        if (session.hasSuperPickAxe()) {
            if ("on".equals(newState)) {
                player.printError("\u0421\u0443\u043f\u0435\u0440-\u043a\u0438\u0440\u043a\u0430 \u0438 \u0442\u0430\u043a \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
                return;
            }
            session.disableSuperPickAxe();
            player.print("\u0421\u0443\u043f\u0435\u0440-\u043a\u0438\u0440\u043a\u0430 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        } else {
            if ("off".equals(newState)) {
                player.printError("\u0421\u0443\u043f\u0435\u0440-\u043a\u0438\u0440\u043a\u0430 \u0438 \u0442\u0430\u043a \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
                return;
            }
            session.enableSuperPickAxe();
            player.print("\u0421\u0443\u043f\u0435\u0440-\u043a\u0438\u0440\u043a\u0430 \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        }
    }

    @Command(aliases={"superpickaxe", "pickaxe", "sp"}, desc="\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u0440\u0435\u0436\u0438\u043c \u0441\u0443\u043f\u0435\u0440-\u043a\u0438\u0440\u043a\u0438")
    @NestedCommand(value={SuperPickaxeCommands.class})
    public void pickaxe(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }

    @Command(aliases={"tool"}, desc="\u0412\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u0434\u043b\u044f \u043f\u0440\u0438\u0432\u044f\u0437\u043a\u0438")
    @NestedCommand(value={ToolCommands.class})
    public void tool(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
    }

    @Command(aliases={"mask"}, usage="[mask]", desc="\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043c\u0430\u0441\u043a\u0443 \u043a\u0438\u0441\u0442\u0438", min=0, max=-1)
    @CommandPermissions(value={"worldedit.brush.options.mask"})
    public void mask(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        if (args.argsLength() == 0) {
            session.getBrushTool(player.getItemInHand()).setMask(null);
            player.print("\u041c\u0430\u0441\u043a\u0430 \u043a\u0438\u0441\u0442\u0438 \u043e\u0447\u0438\u0449\u0435\u043d\u0430.");
        } else {
            Mask mask = this.we.getBlockMask(player, session, args.getJoinedStrings(0));
            session.getBrushTool(player.getItemInHand()).setMask(mask);
            player.print("\u041c\u0430\u0441\u043a\u0430 \u043a\u0438\u0441\u0442\u0438 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430.");
        }
    }

    @Command(aliases={"mat", "material", "fill"}, usage="[pattern]", desc="\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u043a\u0438\u0441\u0442\u0438", min=1, max=1)
    @CommandPermissions(value={"worldedit.brush.options.material"})
    public void material(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        session.getBrushTool(player.getItemInHand()).setFill(pattern);
        player.print("\u041c\u0430\u0442\u0435\u0440\u0438\u0430\u043b \u043a\u0438\u0441\u0442\u0438 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d.");
    }

    @Command(aliases={"range"}, usage="[pattern]", desc="\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043a\u0438\u0441\u0442\u0438", min=1, max=1)
    @CommandPermissions(value={"worldedit.brush.options.range"})
    public void range(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int range = args.getInteger(0);
        session.getBrushTool(player.getItemInHand()).setRange(range);
        player.print("\u0420\u0430\u0437\u043c\u0435\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d.");
    }

    @Command(aliases={"size"}, usage="[pattern]", desc="\u0412\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 \u0440\u0430\u0437\u043c\u0435\u0440 \u043a\u0438\u0441\u0442\u0438", min=1, max=1)
    @CommandPermissions(value={"worldedit.brush.options.size"})
    public void size(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int radius = args.getInteger(0);
        this.we.checkMaxBrushRadius(radius);
        session.getBrushTool(player.getItemInHand()).setSize(radius);
        player.print("\u0420\u0430\u0437\u043c\u0435\u0440 \u043a\u0438\u0441\u0442\u0438 \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d.");
    }
}

