/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.CommandsManager;
import com.sk89q.minecraft.util.commands.Console;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EntityType;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.patterns.Pattern;
import com.sk89q.worldedit.patterns.SingleBlockPattern;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.StringUtil;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class UtilityCommands {
    private final WorldEdit we;

    public UtilityCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"/fill"}, usage="<block> <radius> [depth]", desc="\u0417\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0434\u044b\u0440\u0443", min=2, max=3)
    @CommandPermissions(value={"worldedit.fill"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fill(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        double radius = Math.max(1.0, args.getDouble(1));
        this.we.checkMaxRadius(radius);
        int depth = args.argsLength() > 2 ? Math.max(1, args.getInteger(2)) : 1;
        Vector pos = session.getPlacementPosition(player);
        int affected = 0;
        affected = pattern instanceof SingleBlockPattern ? editSession.fillXZ(pos, ((SingleBlockPattern)pattern).getBlock(), radius, depth, false) : editSession.fillXZ(pos, pattern, radius, depth, false);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u044b " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/fillr"}, usage="<block> <radius> [depth]", desc="\u0420\u0435\u043a\u0443\u0440\u0441\u0438\u0432\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0434\u044b\u0440\u0443", min=2, max=3)
    @CommandPermissions(value={"worldedit.fill.recursive"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fillr(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern pattern = this.we.getBlockPattern(player, args.getString(0));
        double radius = Math.max(1.0, args.getDouble(1));
        this.we.checkMaxRadius(radius);
        int depth = args.argsLength() > 2 ? Math.max(1, args.getInteger(2)) : 1;
        Vector pos = session.getPlacementPosition(player);
        int affected = 0;
        affected = pattern instanceof SingleBlockPattern ? editSession.fillXZ(pos, ((SingleBlockPattern)pattern).getBlock(), radius, depth, true) : editSession.fillXZ(pos, pattern, radius, depth, true);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0441\u043e\u0437\u0434\u0430\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u044b " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0441\u043e\u0437\u0434\u0430\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/drain"}, usage="<radius>", desc="\u041e\u0441\u0443\u0449\u0430\u0435\u0442 \u043e\u0437\u0435\u0440\u0430", min=1, max=1)
    @CommandPermissions(value={"worldedit.drain"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void drain(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radius = Math.max(0.0, args.getDouble(0));
        this.we.checkMaxRadius(radius);
        int affected = editSession.drainArea(session.getPlacementPosition(player), radius);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u044b " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/fixlava", "fixlava"}, usage="<radius>", desc="\u0414\u0435\u043b\u0430\u0435\u0442 \u043b\u0430\u0432\u0443 \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439", min=1, max=1)
    @CommandPermissions(value={"worldedit.fixlava"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fixLava(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radius = Math.max(0.0, args.getDouble(0));
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(player), radius, 10, 11);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u044b " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/fixwater", "fixwater"}, usage="<radius>", desc="\u0414\u0435\u043b\u0430\u0435\u0442 \u0432\u043e\u0434\u0443 \u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0439", min=1, max=1)
    @CommandPermissions(value={"worldedit.fixwater"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void fixWater(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double radius = Math.max(0.0, args.getDouble(0));
        this.we.checkMaxRadius(radius);
        int affected = editSession.fixLiquid(session.getPlacementPosition(player), radius, 8, 9);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0438\u0437\u043c\u0435\u043d\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u044b " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/removeabove", "removeabove"}, usage="[size] [height]", desc="\u0423\u043d\u0438\u0447\u0442\u043e\u0436\u0430\u0435\u0442 \u0431\u043b\u043e\u043a\u0438 \u043d\u0430\u0434 \u0433\u043e\u043b\u043e\u0432\u043e\u0439 \u0438\u0433\u0440\u043e\u043a\u0430.", min=0, max=2)
    @CommandPermissions(value={"worldedit.removeabove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void removeAbove(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 1;
        this.we.checkMaxRadius(size);
        LocalWorld world = player.getWorld();
        int height = args.argsLength() > 1 ? Math.min(world.getMaxY() + 1, args.getInteger(1) + 2) : world.getMaxY() + 1;
        int affected = editSession.removeAbove(session.getPlacementPosition(player), size, height);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/removebelow", "removebelow"}, usage="[size] [height]", desc="\u0423\u043d\u0438\u0447\u0442\u043e\u0436\u0430\u0435\u0442 \u0431\u043b\u043e\u043a\u0438 \u043f\u043e\u0434 \u0438\u0433\u0440\u043e\u043a\u043e\u043c.", min=0, max=2)
    @CommandPermissions(value={"worldedit.removebelow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void removeBelow(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : 1;
        this.we.checkMaxRadius(size);
        LocalWorld world = player.getWorld();
        int height = args.argsLength() > 1 ? Math.min(world.getMaxY() + 1, args.getInteger(1) + 2) : world.getMaxY() + 1;
        int affected = editSession.removeBelow(session.getPlacementPosition(player), size, height);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/removenear", "removenear"}, usage="<block> [size]", desc="\u0423\u043d\u0438\u0447\u0442\u043e\u0436\u0430\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438 \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u0433\u0440\u043e\u043a\u043e\u043c.", min=1, max=2)
    @CommandPermissions(value={"worldedit.removenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void removeNear(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        BaseBlock block = this.we.getBlock(player, args.getString(0), true);
        int size = Math.max(1, args.getInteger(1, 50));
        this.we.checkMaxRadius(size);
        int affected = editSession.removeNear(session.getPlacementPosition(player), block.getType(), size);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/replacenear", "replacenear"}, usage="<size> <from-id> <to-id>", desc="\u0417\u0430\u043c\u0435\u043d\u044f\u0435\u0442 \u0437\u0430\u0434\u0430\u043d\u044b\u0435 \u0431\u043b\u043e\u043a\u0438 \u0440\u044f\u0434\u043e\u043c \u0441 \u0438\u0433\u0440\u043e\u043a\u043e\u043c", flags="f", min=3, max=3)
    @CommandPermissions(value={"worldedit.replacenear"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void replaceNear(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        Pattern to;
        Set<BaseBlock> from;
        int size = Math.max(1, args.getInteger(0));
        if (args.argsLength() == 2) {
            from = null;
            to = this.we.getBlockPattern(player, args.getString(1));
        } else {
            from = this.we.getBlocks(player, args.getString(1), true, !args.hasFlag('f'));
            to = this.we.getBlockPattern(player, args.getString(2));
        }
        Vector base = session.getPlacementPosition(player);
        Vector min = base.subtract(size, size, size);
        Vector max = base.add(size, size, size);
        CuboidRegion region = new CuboidRegion(player.getWorld(), min, max);
        int affected = to instanceof SingleBlockPattern ? editSession.replaceBlocks((Region)region, from, ((SingleBlockPattern)to).getBlock()) : editSession.replaceBlocks((Region)region, from, to);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0437\u0430\u043c\u0435\u043d\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u0438 \u0437\u0430\u043c\u0435\u043d\u0435\u043d\u044b " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0437\u0430\u043c\u0435\u043d\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"/snow", "snow"}, usage="[radius]", desc="\u0418\u043c\u0438\u0442\u0438\u0440\u0443\u0435\u0442 \u0441\u043d\u0435\u0433", min=0, max=1)
    @CommandPermissions(value={"worldedit.snow"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void snow(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double size = args.argsLength() > 0 ? Math.max(1.0, args.getDouble(0)) : 10.0;
        int affected = editSession.simulateSnow(session.getPlacementPosition(player), size);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u043f\u043e\u043a\u0440\u044b\u0442", "\u0431\u043b\u043e\u043a\u0430 \u043f\u043e\u043a\u0440\u044b\u0442\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u043f\u043e\u043a\u0440\u044b\u0442\u043e") + " \u0441\u043d\u0435\u0433\u043e\u043c. \u0414\u0430 \u0431\u0443\u0434\u0435\u0442 \u0441\u043d\u0435\u0433~");
    }

    @Command(aliases={"/thaw", "thaw"}, usage="[radius]", desc="\u0420\u0430\u0437\u043c\u043e\u0440\u0430\u0436\u0438\u0432\u0430\u0435\u0442 \u0437\u043e\u043d\u0443", min=0, max=1)
    @CommandPermissions(value={"worldedit.thaw"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void thaw(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double size = args.argsLength() > 0 ? Math.max(1.0, args.getDouble(0)) : 10.0;
        int affected = editSession.thaw(session.getPlacementPosition(player), size);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u0440\u0430\u0437\u043c\u043e\u0440\u043e\u0436\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u0440\u0430\u0437\u043c\u043e\u0440\u043e\u0436\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u0440\u0430\u0437\u043c\u043e\u0440\u043e\u0436\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/green", "green"}, usage="[radius]", desc="\u041e\u0437\u0435\u043b\u0435\u043d\u044f\u0435\u0442 \u0437\u043e\u043d\u0443", min=0, max=1)
    @CommandPermissions(value={"worldedit.green"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void green(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        double size = args.argsLength() > 0 ? Math.max(1.0, args.getDouble(0)) : 10.0;
        int affected = editSession.green(session.getPlacementPosition(player), size);
        player.print(affected + " " + StringUtil.plural(affected, "\u0431\u043b\u043e\u043a \u043e\u0437\u0435\u043b\u0435\u043d\u0435\u043d", "\u0431\u043b\u043e\u043a\u0430 \u043e\u0437\u0435\u043b\u0435\u043d\u0435\u043d\u043e", "\u0431\u043b\u043e\u043a\u043e\u0432 \u043e\u0437\u0435\u043b\u0435\u043d\u0435\u043d\u043e") + ".");
    }

    @Command(aliases={"/ex", "/ext", "/extinguish", "ex", "ext", "extinguish"}, usage="[radius]", desc="\u0422\u0443\u0448\u0438\u0442 \u043e\u0433\u043e\u043d\u044c \u0432 \u0437\u043e\u043d\u0435", min=0, max=1)
    @CommandPermissions(value={"worldedit.extinguish"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    public void extinguish(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        LocalConfiguration config = this.we.getConfiguration();
        int defaultRadius = config.maxRadius != -1 ? Math.min(40, config.maxRadius) : 40;
        int size = args.argsLength() > 0 ? Math.max(1, args.getInteger(0)) : defaultRadius;
        this.we.checkMaxRadius(size);
        int affected = editSession.removeNear(session.getPlacementPosition(player), 51, size);
        player.print(StringUtil.plural(affected, "\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d " + affected + " " + "\u0431\u043b\u043e\u043a", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u0430", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + affected + " " + "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
    }

    @Command(aliases={"butcher"}, usage="[radius]", flags="plangbf", desc="\u0423\u0431\u0438\u0432\u0430\u0435\u0442 \u0432\u0441\u0435\u043c \u043c\u043e\u0431\u043e\u043c \u0432 \u0437\u043e\u043d\u0435", help="\u0423\u0431\u0438\u0432\u0430\u0435\u0442 \u0432\u0441\u0435\u0445 \u043c\u043e\u0431\u043e\u0432 \u0432 \u0437\u0430\u0434\u0430\u043d\u043e\u043c \u0440\u0430\u0434\u0438\u0443\u0441\u0435. \u0415\u0441\u043b\u0438 \u0440\u0430\u0434\u0438\u0443\u0441 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d, \u0442\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.\n\u0424\u043b\u0430\u0433\u0438:  -p \u0442\u0430\u043a\u0436\u0435 \u0443\u0431\u0438\u0432\u0430\u0435\u0442 \u043f\u0438\u0442\u043e\u043c\u0446\u0435\u0432.\n  -n \u0442\u0430\u043a\u0436\u0435 \u0443\u0431\u0438\u0432\u0430\u0435\u0442 NPC.\n  -g \u0442\u0430\u043a\u0436\u0435 \u0443\u0431\u0438\u0432\u0430\u0435\u0442 \u0413\u043e\u043b\u0435\u043c\u043e\u0432.\n  -a \u0442\u0430\u043a\u0436\u0435 \u0443\u0431\u0438\u0432\u0430\u0435\u0442 \u0436\u0438\u0432\u043e\u0442\u043d\u044b\u0445.\n  -b \u0442\u0430\u043a\u0436\u0435 \u0443\u0431\u0438\u0432\u0430\u0435\u0442 \u043d\u0435\u0439\u0442\u0440\u0430\u043b\u044c\u043d\u044b\u0445 \u043c\u043e\u0431\u043e\u0432.\n  -f \u043e\u0431\u044a\u0435\u0434\u0438\u043d\u044f\u0435\u0442 \u0432\u0441\u0435 \u0432\u044b\u0448\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0435 \u0444\u043b\u0430\u0433\u0438.\n  -l \u0441\u043e\u0437\u0434\u0430\u0435\u0442 \u043c\u043e\u043b\u043d\u0438\u044e \u043f\u0440\u0438 \u0443\u0431\u0438\u0439\u0441\u0442\u0432\u0435 \u043a\u0430\u0436\u0434\u043e\u0433\u043e \u043c\u043e\u0431\u0430.", min=0, max=1)
    @CommandPermissions(value={"worldedit.butcher"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    @Console
    public void butcher(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        int killed;
        LocalConfiguration config = this.we.getConfiguration();
        int radius = config.butcherDefaultRadius;
        if (args.argsLength() > 0) {
            radius = args.getInteger(0);
            if (config.butcherMaxRadius != -1) {
                radius = radius == -1 ? config.butcherMaxRadius : Math.min(radius, config.butcherMaxRadius);
            }
        }
        FlagContainer flags = new FlagContainer(player);
        flags.or(31, args.hasFlag('f'));
        flags.or(1, args.hasFlag('p'), "worldedit.butcher.pets");
        flags.or(2, args.hasFlag('n'), "worldedit.butcher.npcs");
        flags.or(8, args.hasFlag('g'), "worldedit.butcher.golems");
        flags.or(4, args.hasFlag('a'), "worldedit.butcher.animals");
        flags.or(16, args.hasFlag('b'), "worldedit.butcher.ambient");
        flags.or(0x100000, args.hasFlag('l'), "worldedit.butcher.lightning");
        if (player.isPlayer()) {
            killed = player.getWorld().killMobs(session.getPlacementPosition(player), (double)radius, flags.flags);
        } else {
            killed = 0;
            for (LocalWorld world : this.we.getServer().getWorlds()) {
                killed += world.killMobs(new Vector(), (double)radius, flags.flags);
            }
        }
        if (radius < 0) {
            player.print(StringUtil.plural(killed, "\u0411\u044b\u043b \u0443\u0431\u0438\u0442 " + killed + " " + "\u043c\u043e\u0431", "\u0411\u044b\u043b\u043e \u0443\u0431\u0438\u0442\u043e " + killed + " " + "\u043c\u043e\u0431\u0430", "\u0411\u044b\u043b\u043e \u0443\u0431\u0438\u0442\u043e " + killed + " " + "\u043c\u043e\u0431\u043e\u0432") + ".");
        } else {
            player.print(StringUtil.plural(killed, "\u0411\u044b\u043b \u0443\u0431\u0438\u0442 " + killed + " " + "\u043c\u043e\u0431", "\u0411\u044b\u043b\u043e \u0443\u0431\u0438\u0442\u043e " + killed + " " + "\u043c\u043e\u0431\u0430", "\u0411\u044b\u043b\u043e \u0443\u0431\u0438\u0442\u043e " + killed + " " + "\u043c\u043e\u0431\u043e\u0432") + " \u0432 \u0440\u0430\u0434\u0438\u0443\u0441\u0435 " + radius + " " + StringUtil.plural(radius, "\u0431\u043b\u043e\u043a\u0430", "\u0431\u043b\u043e\u043a\u043e\u0432", "\u0431\u043b\u043e\u043a\u043e\u0432") + ".");
        }
    }

    @Command(aliases={"remove", "rem", "rement"}, usage="<type> <radius>", desc="\u0423\u0434\u0430\u043b\u044f\u0435\u0442 \u0432\u0441\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u044b \u0437\u0430\u0434\u0430\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430", min=2, max=2)
    @CommandPermissions(value={"worldedit.remove"})
    @Logging(value=Logging.LogMode.PLACEMENT)
    @Console
    public void remove(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        String typeStr = args.getString(0);
        int radius = args.getInteger(1);
        if (radius < -1) {
            player.printError("\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 \u043a\u043b\u044e\u0447 -1 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f \u0432\u0441\u0435\u0445 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0432 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u043d\u043a\u0430\u0445");
            return;
        }
        EntityType type = null;
        if (typeStr.matches("all")) {
            type = EntityType.ALL;
        } else if (typeStr.matches("projectiles?|arrows?")) {
            type = EntityType.PROJECTILES;
        } else if (typeStr.matches("items?") || typeStr.matches("drops?")) {
            type = EntityType.ITEMS;
        } else if (typeStr.matches("falling(blocks?|sand|gravel)")) {
            type = EntityType.FALLING_BLOCKS;
        } else if (typeStr.matches("paintings?") || typeStr.matches("art")) {
            type = EntityType.PAINTINGS;
        } else if (typeStr.matches("(item)frames?")) {
            type = EntityType.ITEM_FRAMES;
        } else if (typeStr.matches("boats?")) {
            type = EntityType.BOATS;
        } else if (typeStr.matches("minecarts?") || typeStr.matches("carts?")) {
            type = EntityType.MINECARTS;
        } else if (typeStr.matches("tnt")) {
            type = EntityType.TNT;
        } else if (typeStr.matches("xp")) {
            type = EntityType.XP_ORBS;
        } else {
            player.printError("\u0414\u043e\u0441\u0442\u0443\u043f\u044b\u043d\u0435 \u0442\u0438\u043f\u044b: projectiles, items, paintings, itemframes, boats, minecarts, tnt, xp, \u0438 all");
            return;
        }
        int removed = 0;
        if (player.isPlayer()) {
            Vector origin = session.getPlacementPosition(player);
            removed = player.getWorld().removeEntities(type, origin, radius);
        } else {
            for (LocalWorld world : this.we.getServer().getWorlds()) {
                removed += world.removeEntities(type, new Vector(), radius);
            }
        }
        player.print(StringUtil.plural(removed, "\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0435\u043d " + removed + " " + "\u043e\u0431\u044a\u0435\u043a\u0442", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + removed + " " + "\u043e\u0431\u044a\u0435\u043a\u0442\u0430", "\u0411\u044b\u043b\u043e \u0443\u0434\u0430\u043b\u0435\u043d\u043e " + removed + " " + "\u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432") + ".");
    }

    @Command(aliases={"/help"}, usage="[<command>]", desc="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u043f\u0440\u0430\u0432\u043a\u0443 \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0438\u043b\u0438 \u0432\u044b\u0432\u043e\u0434\u0438\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u0430\u043d\u0434.", min=0, max=-1)
    @Console
    @CommandPermissions(value={"worldedit.help"})
    public void help(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        UtilityCommands.help(args, this.we, session, player, editSession);
    }

    public static void help(CommandContext args, WorldEdit we, LocalSession session, LocalPlayer player, EditSession editSession) {
        CommandsManager<LocalPlayer> commandsManager = we.getCommandsManager();
        if (args.argsLength() == 0) {
            TreeSet<String> commands = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int ret = o1.replaceAll("/", "").compareToIgnoreCase(o2.replaceAll("/", ""));
                    if (ret == 0) {
                        return o1.compareToIgnoreCase(o2);
                    }
                    return ret;
                }
            });
            commands.addAll(commandsManager.getCommands().keySet());
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String command : commands) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append('/');
                sb.append(command);
                first = false;
            }
            player.print(sb.toString());
            return;
        }
        String command = args.getJoinedStrings(0).replaceAll("/", "");
        String helpMessage = commandsManager.getHelpMessages().get(command);
        if (helpMessage == null) {
            player.printError("\u041a\u043e\u043c\u0430\u043d\u0434\u0430 '" + command + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.");
            return;
        }
        player.print(helpMessage);
    }

    public static class FlagContainer {
        private final LocalPlayer player;
        public int flags = 0;

        public FlagContainer(LocalPlayer player) {
            this.player = player;
        }

        public void or(int flag, boolean on) {
            if (on) {
                this.flags |= flag;
            }
        }

        public void or(int flag, boolean on, String permission) {
            this.or(flag, on);
            if ((this.flags & flag) != 0 && !this.player.hasPermission(permission)) {
                this.flags &= ~flag;
            }
        }
    }
}

