/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.commands;

import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Console;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalPlayer;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.commands.UtilityCommands;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class WorldEditCommands {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final WorldEdit we;

    public WorldEditCommands(WorldEdit we) {
        this.we = we;
    }

    @Command(aliases={"version", "ver"}, usage="", desc="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0432\u0435\u0440\u0441\u0438\u044e WorldEdit", min=0, max=0)
    @Console
    public void version(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        player.print("WorldEdit version " + WorldEdit.getVersion());
        player.print("http://www.sk89q.com/projects/worldedit/");
        player.print("\u041f\u0435\u0440\u0435\u0432\u043e\u0434 Alex Bond \u0438 Oleg599");
    }

    @Command(aliases={"reload"}, usage="", desc="\u041f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u0442 WorldEdit", min=0, max=0)
    @CommandPermissions(value={"worldedit.reload"})
    @Console
    public void reload(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        this.we.getServer().reload();
        player.print("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!");
    }

    @Command(aliases={"cui"}, usage="", desc="\u0418\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u0443\u0435\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 CUI", min=0, max=0)
    public void cui(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        session.setCUISupport(true);
        session.dispatchCUISetup(player);
    }

    @Command(aliases={"tz"}, usage="[\u0437\u043e\u043d\u0430]", desc="\u0423\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0412\u0430\u0448 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u044f\u0441", min=1, max=1)
    @Console
    public void tz(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        TimeZone tz = TimeZone.getTimeZone(args.getString(0));
        session.setTimezone(tz);
        player.print("\u0414\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0439 \u0441\u0435\u0441\u0441\u0438\u0438 \u0443\u043a\u0430\u0437\u0430\u043d\u0430\u044f \u043d\u043e\u0432\u0430\u044f \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430: " + tz.getDisplayName());
        player.print("\u0422\u0435\u043a\u0443\u0449\u0435\u0435 \u0432\u0440\u0435\u043c\u044f \u0432 \u0412\u0430\u0448\u0435\u0439 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u0435: " + dateFormat.format(Calendar.getInstance(tz).getTime()));
    }

    @Command(aliases={"help"}, usage="[<\u043a\u043e\u043c\u0430\u043d\u0434\u0430>]", desc="\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u0441\u043f\u0440\u0430\u0432\u043a\u0443 \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u0438\u043b\u0438 \u0432\u044b\u0432\u043e\u0434\u0438\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u0430\u043d\u0434.", min=0, max=-1)
    @CommandPermissions(value={"worldedit.help"})
    @Console
    public void help(CommandContext args, LocalSession session, LocalPlayer player, EditSession editSession) throws WorldEditException {
        UtilityCommands.help(args, this.we, session, player, editSession);
    }
}

