/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.shape;

import com.sk89q.worldedit.BiomeType;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;

public abstract class ArbitraryBiomeShape {
    private final FlatRegion extent;
    private int cacheOffsetX;
    private int cacheOffsetZ;
    private int cacheSizeX;
    private int cacheSizeZ;
    private final BiomeType[] cache;
    private static final BiomeType OUTSIDE = new BiomeType(){

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }
    };

    public ArbitraryBiomeShape(Region extent) {
        this.extent = extent instanceof FlatRegion ? (FlatRegion)extent : new CuboidRegion(extent.getWorld(), extent.getMinimumPoint(), extent.getMaximumPoint());
        Vector2D min = extent.getMinimumPoint().toVector2D();
        Vector2D max = extent.getMaximumPoint().toVector2D();
        this.cacheOffsetX = min.getBlockX() - 1;
        this.cacheOffsetZ = min.getBlockZ() - 1;
        this.cacheSizeX = (int)(max.getX() - (double)this.cacheOffsetX + 2.0);
        this.cacheSizeZ = (int)(max.getZ() - (double)this.cacheOffsetZ + 2.0);
        this.cache = new BiomeType[this.cacheSizeX * this.cacheSizeZ];
    }

    protected Iterable<Vector2D> getExtent() {
        return this.extent.asFlatRegion();
    }

    protected abstract BiomeType getBiome(int var1, int var2, BiomeType var3);

    private BiomeType getBiomeCached(int x, int z, BiomeType biomeType) {
        int index = z - this.cacheOffsetZ + (x - this.cacheOffsetX) * this.cacheSizeZ;
        BiomeType cacheEntry = this.cache[index];
        if (cacheEntry == null) {
            BiomeType material = this.getBiome(x, z, biomeType);
            if (material == null) {
                this.cache[index] = OUTSIDE;
                return null;
            }
            this.cache[index] = material;
            return material;
        }
        if (cacheEntry == OUTSIDE) {
            return null;
        }
        return cacheEntry;
    }

    private boolean isInsideCached(int x, int z, BiomeType biomeType) {
        int index = z - this.cacheOffsetZ + (x - this.cacheOffsetX) * this.cacheSizeZ;
        BiomeType cacheEntry = this.cache[index];
        if (cacheEntry == null) {
            return this.getBiomeCached(x, z, biomeType) != null;
        }
        return cacheEntry != OUTSIDE;
    }

    public int generate(EditSession editSession, BiomeType biomeType, boolean hollow) {
        int affected = 0;
        for (Vector2D position : this.getExtent()) {
            BiomeType material;
            int x = position.getBlockX();
            int z = position.getBlockZ();
            if (!hollow) {
                material = this.getBiome(x, z, biomeType);
                if (material == OUTSIDE) continue;
                editSession.getWorld().setBiome(position, material);
                ++affected;
                continue;
            }
            material = this.getBiomeCached(x, z, biomeType);
            if (material == null) continue;
            boolean draw = false;
            if (!this.isInsideCached(x + 1, z, biomeType)) {
                draw = true;
            } else if (!this.isInsideCached(x - 1, z, biomeType)) {
                draw = true;
            } else if (!this.isInsideCached(x, z + 1, biomeType)) {
                draw = true;
            } else if (!this.isInsideCached(x, z - 1, biomeType)) {
                draw = true;
            }
            if (!draw) continue;
            editSession.getWorld().setBiome(position, material);
            ++affected;
        }
        return affected;
    }
}

